/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about the Malware Protection plan resource.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionPlanSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MalwareProtectionPlanSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * A unique identifier associated with Malware Protection plan.
     * </p>
     */
    private String malwareProtectionPlanId;

    /**
     * <p>
     * A unique identifier associated with Malware Protection plan.
     * </p>
     * 
     * @param malwareProtectionPlanId
     *        A unique identifier associated with Malware Protection plan.
     */

    public void setMalwareProtectionPlanId(String malwareProtectionPlanId) {
        this.malwareProtectionPlanId = malwareProtectionPlanId;
    }

    /**
     * <p>
     * A unique identifier associated with Malware Protection plan.
     * </p>
     * 
     * @return A unique identifier associated with Malware Protection plan.
     */

    public String getMalwareProtectionPlanId() {
        return this.malwareProtectionPlanId;
    }

    /**
     * <p>
     * A unique identifier associated with Malware Protection plan.
     * </p>
     * 
     * @param malwareProtectionPlanId
     *        A unique identifier associated with Malware Protection plan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MalwareProtectionPlanSummary withMalwareProtectionPlanId(String malwareProtectionPlanId) {
        setMalwareProtectionPlanId(malwareProtectionPlanId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMalwareProtectionPlanId() != null)
            sb.append("MalwareProtectionPlanId: ").append(getMalwareProtectionPlanId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MalwareProtectionPlanSummary == false)
            return false;
        MalwareProtectionPlanSummary other = (MalwareProtectionPlanSummary) obj;
        if (other.getMalwareProtectionPlanId() == null ^ this.getMalwareProtectionPlanId() == null)
            return false;
        if (other.getMalwareProtectionPlanId() != null && other.getMalwareProtectionPlanId().equals(this.getMalwareProtectionPlanId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMalwareProtectionPlanId() == null) ? 0 : getMalwareProtectionPlanId().hashCode());
        return hashCode;
    }

    @Override
    public MalwareProtectionPlanSummary clone() {
        try {
            return (MalwareProtectionPlanSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.guardduty.model.transform.MalwareProtectionPlanSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
