/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.glue.model.CatalogEntry;
import com.amazonaws.services.glue.model.Language;
import com.amazonaws.services.glue.model.Location;
import com.amazonaws.services.glue.model.MappingEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetPlanRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<MappingEntry> mapping;
    private CatalogEntry source;
    private List<CatalogEntry> sinks;
    private Location location;
    private String language;

    public List<MappingEntry> getMapping() {
        return this.mapping;
    }

    public void setMapping(Collection<MappingEntry> mapping) {
        if (mapping == null) {
            this.mapping = null;
            return;
        }
        this.mapping = new ArrayList<MappingEntry>(mapping);
    }

    public GetPlanRequest withMapping(MappingEntry ... mapping) {
        if (this.mapping == null) {
            this.setMapping(new ArrayList<MappingEntry>(mapping.length));
        }
        for (MappingEntry ele : mapping) {
            this.mapping.add(ele);
        }
        return this;
    }

    public GetPlanRequest withMapping(Collection<MappingEntry> mapping) {
        this.setMapping(mapping);
        return this;
    }

    public void setSource(CatalogEntry source) {
        this.source = source;
    }

    public CatalogEntry getSource() {
        return this.source;
    }

    public GetPlanRequest withSource(CatalogEntry source) {
        this.setSource(source);
        return this;
    }

    public List<CatalogEntry> getSinks() {
        return this.sinks;
    }

    public void setSinks(Collection<CatalogEntry> sinks) {
        if (sinks == null) {
            this.sinks = null;
            return;
        }
        this.sinks = new ArrayList<CatalogEntry>(sinks);
    }

    public GetPlanRequest withSinks(CatalogEntry ... sinks) {
        if (this.sinks == null) {
            this.setSinks(new ArrayList<CatalogEntry>(sinks.length));
        }
        for (CatalogEntry ele : sinks) {
            this.sinks.add(ele);
        }
        return this;
    }

    public GetPlanRequest withSinks(Collection<CatalogEntry> sinks) {
        this.setSinks(sinks);
        return this;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public GetPlanRequest withLocation(Location location) {
        this.setLocation(location);
        return this;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public GetPlanRequest withLanguage(String language) {
        this.setLanguage(language);
        return this;
    }

    public GetPlanRequest withLanguage(Language language) {
        this.language = language.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMapping() != null) {
            sb.append("Mapping: ").append(this.getMapping()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getSinks() != null) {
            sb.append("Sinks: ").append(this.getSinks()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getLanguage() != null) {
            sb.append("Language: ").append(this.getLanguage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanRequest)) {
            return false;
        }
        GetPlanRequest other = (GetPlanRequest)obj;
        if (other.getMapping() == null ^ this.getMapping() == null) {
            return false;
        }
        if (other.getMapping() != null && !other.getMapping().equals(this.getMapping())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getSinks() == null ^ this.getSinks() == null) {
            return false;
        }
        if (other.getSinks() != null && !other.getSinks().equals(this.getSinks())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getLanguage() == null ^ this.getLanguage() == null) {
            return false;
        }
        return other.getLanguage() == null || other.getLanguage().equals(this.getLanguage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMapping() == null ? 0 : this.getMapping().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getSinks() == null ? 0 : this.getSinks().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getLanguage() == null ? 0 : this.getLanguage().hashCode());
        return hashCode;
    }

    public GetPlanRequest clone() {
        return (GetPlanRequest)super.clone();
    }
}

