/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.NotificationProperty;
import com.amazonaws.services.glue.model.transform.ActionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Action
implements Serializable,
Cloneable,
StructuredPojo {
    private String jobName;
    private Map<String, String> arguments;
    private Integer timeout;
    private NotificationProperty notificationProperty;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Action withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    public Action withArguments(Map<String, String> arguments) {
        this.setArguments(arguments);
        return this;
    }

    public Action addArgumentsEntry(String key, String value) {
        if (null == this.arguments) {
            this.arguments = new HashMap<String, String>();
        }
        if (this.arguments.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.arguments.put(key, value);
        return this;
    }

    public Action clearArgumentsEntries() {
        this.arguments = null;
        return this;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Action withTimeout(Integer timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public void setNotificationProperty(NotificationProperty notificationProperty) {
        this.notificationProperty = notificationProperty;
    }

    public NotificationProperty getNotificationProperty() {
        return this.notificationProperty;
    }

    public Action withNotificationProperty(NotificationProperty notificationProperty) {
        this.setNotificationProperty(notificationProperty);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getArguments() != null) {
            sb.append("Arguments: ").append(this.getArguments()).append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout()).append(",");
        }
        if (this.getNotificationProperty() != null) {
            sb.append("NotificationProperty: ").append(this.getNotificationProperty());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getArguments() == null ^ this.getArguments() == null) {
            return false;
        }
        if (other.getArguments() != null && !other.getArguments().equals(this.getArguments())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        if (other.getTimeout() != null && !other.getTimeout().equals(this.getTimeout())) {
            return false;
        }
        if (other.getNotificationProperty() == null ^ this.getNotificationProperty() == null) {
            return false;
        }
        return other.getNotificationProperty() == null || other.getNotificationProperty().equals(this.getNotificationProperty());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getArguments() == null ? 0 : this.getArguments().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationProperty() == null ? 0 : this.getNotificationProperty().hashCode());
        return hashCode;
    }

    public Action clone() {
        try {
            return (Action)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

