/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.PredictorMonitorEvaluation;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PredictorMonitorEvaluationMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<String> MONITORARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MonitorArn").build();
    private static final MarshallingInfo<Date> EVALUATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> EVALUATIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationState").build();
    private static final MarshallingInfo<Date> WINDOWSTARTDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowStartDatetime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> WINDOWENDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowEndDatetime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> PREDICTOREVENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredictorEvent").build();
    private static final MarshallingInfo<StructuredPojo> MONITORDATASOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MonitorDataSource").build();
    private static final MarshallingInfo<List> METRICRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricResults").build();
    private static final MarshallingInfo<Long> NUMITEMSEVALUATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumItemsEvaluated").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final PredictorMonitorEvaluationMarshaller instance = new PredictorMonitorEvaluationMarshaller();

    public static PredictorMonitorEvaluationMarshaller getInstance() {
        return instance;
    }

    public void marshall(PredictorMonitorEvaluation predictorMonitorEvaluation, ProtocolMarshaller protocolMarshaller) {
        if (predictorMonitorEvaluation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getMonitorArn(), MONITORARN_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getEvaluationTime(), EVALUATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getEvaluationState(), EVALUATIONSTATE_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getWindowStartDatetime(), WINDOWSTARTDATETIME_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getWindowEndDatetime(), WINDOWENDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getPredictorEvent(), PREDICTOREVENT_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getMonitorDataSource(), MONITORDATASOURCE_BINDING);
            protocolMarshaller.marshall(predictorMonitorEvaluation.getMetricResults(), METRICRESULTS_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getNumItemsEvaluated(), NUMITEMSEVALUATED_BINDING);
            protocolMarshaller.marshall((Object)predictorMonitorEvaluation.getMessage(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

