/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.eventbridge.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPermission" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutPermissionRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the event bus associated with the rule. If you omit this, the default event bus is used.
     * </p>
     */
    private String eventBusName;
    /**
     * <p>
     * The action that you are enabling the other account to perform.
     * </p>
     */
    private String action;
    /**
     * <p>
     * The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus.
     * Specify "*" to permit any account to put events to your default event bus.
     * </p>
     * <p>
     * If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable
     * events. To create more secure rules, make sure that the event pattern for each rule contains an
     * <code>account</code> field with a specific account ID from which to receive events. Rules with an account field
     * do not match any events sent from other accounts.
     * </p>
     */
    private String principal;
    /**
     * <p>
     * An identifier string for the external account that you are granting permissions to. If you later want to revoke
     * the permission for this external account, specify this <code>StatementId</code> when you run <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html"
     * >RemovePermission</a>.
     * </p>
     * <note>
     * <p>
     * Each <code>StatementId</code> must be unique.
     * </p>
     * </note>
     */
    private String statementId;
    /**
     * <p>
     * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a
     * member of a certain Amazon Web Services organization. For more information about Amazon Web Services
     * Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web
     * Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.
     * </p>
     * <p>
     * If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value
     * for <code>Principal</code>, you grant permission to all the accounts in the named organization.
     * </p>
     * <p>
     * The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and
     * <code>Value</code> fields.
     * </p>
     */
    private Condition condition;
    /**
     * <p>
     * A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in
     * the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or
     * <code>Condition</code> parameters.
     * </p>
     */
    private String policy;

    /**
     * <p>
     * The name of the event bus associated with the rule. If you omit this, the default event bus is used.
     * </p>
     * 
     * @param eventBusName
     *        The name of the event bus associated with the rule. If you omit this, the default event bus is used.
     */

    public void setEventBusName(String eventBusName) {
        this.eventBusName = eventBusName;
    }

    /**
     * <p>
     * The name of the event bus associated with the rule. If you omit this, the default event bus is used.
     * </p>
     * 
     * @return The name of the event bus associated with the rule. If you omit this, the default event bus is used.
     */

    public String getEventBusName() {
        return this.eventBusName;
    }

    /**
     * <p>
     * The name of the event bus associated with the rule. If you omit this, the default event bus is used.
     * </p>
     * 
     * @param eventBusName
     *        The name of the event bus associated with the rule. If you omit this, the default event bus is used.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutPermissionRequest withEventBusName(String eventBusName) {
        setEventBusName(eventBusName);
        return this;
    }

    /**
     * <p>
     * The action that you are enabling the other account to perform.
     * </p>
     * 
     * @param action
     *        The action that you are enabling the other account to perform.
     */

    public void setAction(String action) {
        this.action = action;
    }

    /**
     * <p>
     * The action that you are enabling the other account to perform.
     * </p>
     * 
     * @return The action that you are enabling the other account to perform.
     */

    public String getAction() {
        return this.action;
    }

    /**
     * <p>
     * The action that you are enabling the other account to perform.
     * </p>
     * 
     * @param action
     *        The action that you are enabling the other account to perform.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutPermissionRequest withAction(String action) {
        setAction(action);
        return this;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus.
     * Specify "*" to permit any account to put events to your default event bus.
     * </p>
     * <p>
     * If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable
     * events. To create more secure rules, make sure that the event pattern for each rule contains an
     * <code>account</code> field with a specific account ID from which to receive events. Rules with an account field
     * do not match any events sent from other accounts.
     * </p>
     * 
     * @param principal
     *        The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event
     *        bus. Specify "*" to permit any account to put events to your default event bus.</p>
     *        <p>
     *        If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match
     *        undesirable events. To create more secure rules, make sure that the event pattern for each rule contains
     *        an <code>account</code> field with a specific account ID from which to receive events. Rules with an
     *        account field do not match any events sent from other accounts.
     */

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus.
     * Specify "*" to permit any account to put events to your default event bus.
     * </p>
     * <p>
     * If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable
     * events. To create more secure rules, make sure that the event pattern for each rule contains an
     * <code>account</code> field with a specific account ID from which to receive events. Rules with an account field
     * do not match any events sent from other accounts.
     * </p>
     * 
     * @return The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event
     *         bus. Specify "*" to permit any account to put events to your default event bus.</p>
     *         <p>
     *         If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match
     *         undesirable events. To create more secure rules, make sure that the event pattern for each rule contains
     *         an <code>account</code> field with a specific account ID from which to receive events. Rules with an
     *         account field do not match any events sent from other accounts.
     */

    public String getPrincipal() {
        return this.principal;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus.
     * Specify "*" to permit any account to put events to your default event bus.
     * </p>
     * <p>
     * If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable
     * events. To create more secure rules, make sure that the event pattern for each rule contains an
     * <code>account</code> field with a specific account ID from which to receive events. Rules with an account field
     * do not match any events sent from other accounts.
     * </p>
     * 
     * @param principal
     *        The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event
     *        bus. Specify "*" to permit any account to put events to your default event bus.</p>
     *        <p>
     *        If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match
     *        undesirable events. To create more secure rules, make sure that the event pattern for each rule contains
     *        an <code>account</code> field with a specific account ID from which to receive events. Rules with an
     *        account field do not match any events sent from other accounts.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutPermissionRequest withPrincipal(String principal) {
        setPrincipal(principal);
        return this;
    }

    /**
     * <p>
     * An identifier string for the external account that you are granting permissions to. If you later want to revoke
     * the permission for this external account, specify this <code>StatementId</code> when you run <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html"
     * >RemovePermission</a>.
     * </p>
     * <note>
     * <p>
     * Each <code>StatementId</code> must be unique.
     * </p>
     * </note>
     * 
     * @param statementId
     *        An identifier string for the external account that you are granting permissions to. If you later want to
     *        revoke the permission for this external account, specify this <code>StatementId</code> when you run <a
     *        href
     *        ="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission
     *        </a>.</p> <note>
     *        <p>
     *        Each <code>StatementId</code> must be unique.
     *        </p>
     */

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    /**
     * <p>
     * An identifier string for the external account that you are granting permissions to. If you later want to revoke
     * the permission for this external account, specify this <code>StatementId</code> when you run <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html"
     * >RemovePermission</a>.
     * </p>
     * <note>
     * <p>
     * Each <code>StatementId</code> must be unique.
     * </p>
     * </note>
     * 
     * @return An identifier string for the external account that you are granting permissions to. If you later want to
     *         revoke the permission for this external account, specify this <code>StatementId</code> when you run <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">
     *         RemovePermission</a>.</p> <note>
     *         <p>
     *         Each <code>StatementId</code> must be unique.
     *         </p>
     */

    public String getStatementId() {
        return this.statementId;
    }

    /**
     * <p>
     * An identifier string for the external account that you are granting permissions to. If you later want to revoke
     * the permission for this external account, specify this <code>StatementId</code> when you run <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html"
     * >RemovePermission</a>.
     * </p>
     * <note>
     * <p>
     * Each <code>StatementId</code> must be unique.
     * </p>
     * </note>
     * 
     * @param statementId
     *        An identifier string for the external account that you are granting permissions to. If you later want to
     *        revoke the permission for this external account, specify this <code>StatementId</code> when you run <a
     *        href
     *        ="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission
     *        </a>.</p> <note>
     *        <p>
     *        Each <code>StatementId</code> must be unique.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutPermissionRequest withStatementId(String statementId) {
        setStatementId(statementId);
        return this;
    }

    /**
     * <p>
     * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a
     * member of a certain Amazon Web Services organization. For more information about Amazon Web Services
     * Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web
     * Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.
     * </p>
     * <p>
     * If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value
     * for <code>Principal</code>, you grant permission to all the accounts in the named organization.
     * </p>
     * <p>
     * The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and
     * <code>Value</code> fields.
     * </p>
     * 
     * @param condition
     *        This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as
     *        being a member of a certain Amazon Web Services organization. For more information about Amazon Web
     *        Services Organizations, see <a
     *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon
     *        Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
     *        <p>
     *        If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the
     *        value for <code>Principal</code>, you grant permission to all the accounts in the named organization.
     *        </p>
     *        <p>
     *        The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and
     *        <code>Value</code> fields.
     */

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    /**
     * <p>
     * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a
     * member of a certain Amazon Web Services organization. For more information about Amazon Web Services
     * Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web
     * Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.
     * </p>
     * <p>
     * If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value
     * for <code>Principal</code>, you grant permission to all the accounts in the named organization.
     * </p>
     * <p>
     * The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and
     * <code>Value</code> fields.
     * </p>
     * 
     * @return This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as
     *         being a member of a certain Amazon Web Services organization. For more information about Amazon Web
     *         Services Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon
     *         Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
     *         <p>
     *         If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the
     *         value for <code>Principal</code>, you grant permission to all the accounts in the named organization.
     *         </p>
     *         <p>
     *         The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and
     *         <code>Value</code> fields.
     */

    public Condition getCondition() {
        return this.condition;
    }

    /**
     * <p>
     * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a
     * member of a certain Amazon Web Services organization. For more information about Amazon Web Services
     * Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web
     * Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.
     * </p>
     * <p>
     * If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value
     * for <code>Principal</code>, you grant permission to all the accounts in the named organization.
     * </p>
     * <p>
     * The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and
     * <code>Value</code> fields.
     * </p>
     * 
     * @param condition
     *        This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as
     *        being a member of a certain Amazon Web Services organization. For more information about Amazon Web
     *        Services Organizations, see <a
     *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon
     *        Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
     *        <p>
     *        If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the
     *        value for <code>Principal</code>, you grant permission to all the accounts in the named organization.
     *        </p>
     *        <p>
     *        The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and
     *        <code>Value</code> fields.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutPermissionRequest withCondition(Condition condition) {
        setCondition(condition);
        return this;
    }

    /**
     * <p>
     * A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in
     * the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or
     * <code>Condition</code> parameters.
     * </p>
     * 
     * @param policy
     *        A JSON string that describes the permission policy statement. You can include a <code>Policy</code>
     *        parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>,
     *        <code>Principal</code>, or <code>Condition</code> parameters.
     */

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    /**
     * <p>
     * A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in
     * the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or
     * <code>Condition</code> parameters.
     * </p>
     * 
     * @return A JSON string that describes the permission policy statement. You can include a <code>Policy</code>
     *         parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>,
     *         <code>Principal</code>, or <code>Condition</code> parameters.
     */

    public String getPolicy() {
        return this.policy;
    }

    /**
     * <p>
     * A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in
     * the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or
     * <code>Condition</code> parameters.
     * </p>
     * 
     * @param policy
     *        A JSON string that describes the permission policy statement. You can include a <code>Policy</code>
     *        parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>,
     *        <code>Principal</code>, or <code>Condition</code> parameters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutPermissionRequest withPolicy(String policy) {
        setPolicy(policy);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEventBusName() != null)
            sb.append("EventBusName: ").append(getEventBusName()).append(",");
        if (getAction() != null)
            sb.append("Action: ").append(getAction()).append(",");
        if (getPrincipal() != null)
            sb.append("Principal: ").append(getPrincipal()).append(",");
        if (getStatementId() != null)
            sb.append("StatementId: ").append(getStatementId()).append(",");
        if (getCondition() != null)
            sb.append("Condition: ").append(getCondition()).append(",");
        if (getPolicy() != null)
            sb.append("Policy: ").append(getPolicy());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutPermissionRequest == false)
            return false;
        PutPermissionRequest other = (PutPermissionRequest) obj;
        if (other.getEventBusName() == null ^ this.getEventBusName() == null)
            return false;
        if (other.getEventBusName() != null && other.getEventBusName().equals(this.getEventBusName()) == false)
            return false;
        if (other.getAction() == null ^ this.getAction() == null)
            return false;
        if (other.getAction() != null && other.getAction().equals(this.getAction()) == false)
            return false;
        if (other.getPrincipal() == null ^ this.getPrincipal() == null)
            return false;
        if (other.getPrincipal() != null && other.getPrincipal().equals(this.getPrincipal()) == false)
            return false;
        if (other.getStatementId() == null ^ this.getStatementId() == null)
            return false;
        if (other.getStatementId() != null && other.getStatementId().equals(this.getStatementId()) == false)
            return false;
        if (other.getCondition() == null ^ this.getCondition() == null)
            return false;
        if (other.getCondition() != null && other.getCondition().equals(this.getCondition()) == false)
            return false;
        if (other.getPolicy() == null ^ this.getPolicy() == null)
            return false;
        if (other.getPolicy() != null && other.getPolicy().equals(this.getPolicy()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEventBusName() == null) ? 0 : getEventBusName().hashCode());
        hashCode = prime * hashCode + ((getAction() == null) ? 0 : getAction().hashCode());
        hashCode = prime * hashCode + ((getPrincipal() == null) ? 0 : getPrincipal().hashCode());
        hashCode = prime * hashCode + ((getStatementId() == null) ? 0 : getStatementId().hashCode());
        hashCode = prime * hashCode + ((getCondition() == null) ? 0 : getCondition().hashCode());
        hashCode = prime * hashCode + ((getPolicy() == null) ? 0 : getPolicy().hashCode());
        return hashCode;
    }

    @Override
    public PutPermissionRequest clone() {
        return (PutPermissionRequest) super.clone();
    }

}
