/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.CaptionFormat;
import com.amazonaws.services.elastictranscoder.model.CaptionSource;
import com.amazonaws.services.elastictranscoder.model.Captions;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionFormatJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionSourceJsonMarshaller;

public class CaptionsJsonMarshaller {
    private static CaptionsJsonMarshaller instance;

    public void marshall(Captions captions, StructuredJsonGenerator jsonGenerator) {
        if (captions == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList captionFormatsList;
            SdkInternalList captionSourcesList;
            jsonGenerator.writeStartObject();
            if (captions.getMergePolicy() != null) {
                jsonGenerator.writeFieldName("MergePolicy").writeValue(captions.getMergePolicy());
            }
            if (!(captionSourcesList = (SdkInternalList)captions.getCaptionSources()).isEmpty() || !captionSourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CaptionSources");
                jsonGenerator.writeStartArray();
                for (CaptionSource captionSourcesListValue : captionSourcesList) {
                    if (captionSourcesListValue == null) continue;
                    CaptionSourceJsonMarshaller.getInstance().marshall(captionSourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(captionFormatsList = (SdkInternalList)captions.getCaptionFormats()).isEmpty() || !captionFormatsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CaptionFormats");
                jsonGenerator.writeStartArray();
                for (CaptionFormat captionFormatsListValue : captionFormatsList) {
                    if (captionFormatsListValue == null) continue;
                    CaptionFormatJsonMarshaller.getInstance().marshall(captionFormatsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CaptionsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CaptionsJsonMarshaller();
        }
        return instance;
    }
}

