/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest;
import com.amazonaws.services.ec2.model.DeregisterInstanceTagAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeregisterInstanceEventNotificationAttributesRequestMarshaller
implements Marshaller<Request<DeregisterInstanceEventNotificationAttributesRequest>, DeregisterInstanceEventNotificationAttributesRequest> {
    public Request<DeregisterInstanceEventNotificationAttributesRequest> marshall(DeregisterInstanceEventNotificationAttributesRequest deregisterInstanceEventNotificationAttributesRequest) {
        if (deregisterInstanceEventNotificationAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deregisterInstanceEventNotificationAttributesRequest, "AmazonEC2");
        request.addParameter("Action", "DeregisterInstanceEventNotificationAttributes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        DeregisterInstanceTagAttributeRequest instanceTagAttribute = deregisterInstanceEventNotificationAttributesRequest.getInstanceTagAttribute();
        if (instanceTagAttribute != null) {
            SdkInternalList deregisterInstanceTagAttributeRequestInstanceTagKeysList;
            if (instanceTagAttribute.getIncludeAllTagsOfInstance() != null) {
                request.addParameter("InstanceTagAttribute.IncludeAllTagsOfInstance", StringUtils.fromBoolean((Boolean)instanceTagAttribute.getIncludeAllTagsOfInstance()));
            }
            if (!(deregisterInstanceTagAttributeRequestInstanceTagKeysList = (SdkInternalList)instanceTagAttribute.getInstanceTagKeys()).isEmpty() || !deregisterInstanceTagAttributeRequestInstanceTagKeysList.isAutoConstruct()) {
                int instanceTagKeysListIndex = 1;
                for (String deregisterInstanceTagAttributeRequestInstanceTagKeysListValue : deregisterInstanceTagAttributeRequestInstanceTagKeysList) {
                    if (deregisterInstanceTagAttributeRequestInstanceTagKeysListValue != null) {
                        request.addParameter("InstanceTagAttribute.InstanceTagKey." + instanceTagKeysListIndex, StringUtils.fromString((String)deregisterInstanceTagAttributeRequestInstanceTagKeysListValue));
                    }
                    ++instanceTagKeysListIndex;
                }
            }
        }
        return request;
    }
}

