/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.costexplorer.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.costexplorer.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AnomalyMonitor JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AnomalyMonitorJsonUnmarshaller implements Unmarshaller<AnomalyMonitor, JsonUnmarshallerContext> {

    public AnomalyMonitor unmarshall(JsonUnmarshallerContext context) throws Exception {
        AnomalyMonitor anomalyMonitor = new AnomalyMonitor();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("MonitorArn", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setMonitorArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MonitorName", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setMonitorName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setCreationDate(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastUpdatedDate", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setLastUpdatedDate(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastEvaluatedDate", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setLastEvaluatedDate(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MonitorType", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setMonitorType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MonitorDimension", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setMonitorDimension(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MonitorSpecification", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setMonitorSpecification(ExpressionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DimensionalValueCount", targetDepth)) {
                    context.nextToken();
                    anomalyMonitor.setDimensionalValueCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return anomalyMonitor;
    }

    private static AnomalyMonitorJsonUnmarshaller instance;

    public static AnomalyMonitorJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AnomalyMonitorJsonUnmarshaller();
        return instance;
    }
}
