/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.NotificationWithSubscribers;
import com.amazonaws.services.budgets.model.Subscriber;
import com.amazonaws.services.budgets.model.transform.NotificationJsonMarshaller;
import com.amazonaws.services.budgets.model.transform.SubscriberJsonMarshaller;
import java.util.List;

public class NotificationWithSubscribersJsonMarshaller {
    private static NotificationWithSubscribersJsonMarshaller instance;

    public void marshall(NotificationWithSubscribers notificationWithSubscribers, StructuredJsonGenerator jsonGenerator) {
        if (notificationWithSubscribers == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Subscriber> subscribersList;
            jsonGenerator.writeStartObject();
            if (notificationWithSubscribers.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(notificationWithSubscribers.getNotification(), jsonGenerator);
            }
            if ((subscribersList = notificationWithSubscribers.getSubscribers()) != null) {
                jsonGenerator.writeFieldName("Subscribers");
                jsonGenerator.writeStartArray();
                for (Subscriber subscribersListValue : subscribersList) {
                    if (subscribersListValue == null) continue;
                    SubscriberJsonMarshaller.getInstance().marshall(subscribersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NotificationWithSubscribersJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NotificationWithSubscribersJsonMarshaller();
        }
        return instance;
    }
}

