/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SQSMessagingClientUtil {
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';
    private static final char DOT = '.';
    private static final Pattern ILLEGAL_ATTRIBUTE_NAME_PATTERN = Pattern.compile("_([0-9]+)_");

    public static String serializePropertyName(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char ch : name.toCharArray()) {
            if (Character.isLetterOrDigit(ch) || '-' == ch || '.' == ch) {
                stringBuilder.append(ch);
                continue;
            }
            stringBuilder.append('_').append(Integer.toString(ch)).append('_');
        }
        return stringBuilder.toString();
    }

    public static String deserializePropertyName(String name) {
        String result = name;
        Matcher m = ILLEGAL_ATTRIBUTE_NAME_PATTERN.matcher(result);
        while (m.find()) {
            int charValue = Integer.parseInt(m.group(1));
            result = result.replace("_" + charValue + "_", Character.toString((char)charValue));
        }
        return result;
    }
}

