/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ImageUtilities {
    private static final int DEFAULT_IMAGE_TYPE = 1;

    public BufferedImage bufferImage(Image image) {
        return this.bufferImage(image, 1);
    }

    public BufferedImage bufferImage(Image image, int type) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, null, null);
        this.waitForImage(bufferedImage);
        return bufferedImage;
    }

    private void waitForImage(BufferedImage bufferedImage) {
        final ImageLoadStatus imageLoadStatus = new ImageLoadStatus();
        bufferedImage.getHeight(new ImageObserver(){

            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (infoflags == 32) {
                    imageLoadStatus.heightDone = true;
                    return true;
                }
                return false;
            }
        });
        bufferedImage.getWidth(new ImageObserver(){

            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (infoflags == 32) {
                    imageLoadStatus.widthDone = true;
                    return true;
                }
                return false;
            }
        });
        while (!imageLoadStatus.widthDone && !imageLoadStatus.heightDone) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class ImageLoadStatus {
        public boolean widthDone = false;
        public boolean heightDone = false;

        ImageLoadStatus() {
        }
    }
}

