/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.uploader;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.REST;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.AuthUtilities;
import com.aetrion.flickr.uploader.UploadMetaData;
import com.aetrion.flickr.uploader.UploaderResponse;
import com.aetrion.flickr.util.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Uploader {
    private String apiKey;
    private String sharedSecret;
    private Transport transport;

    public Uploader(String apiKey, String sharedSecret) {
        try {
            this.apiKey = apiKey;
            this.sharedSecret = sharedSecret;
            this.transport = new REST();
            this.transport.setResponseClass(UploaderResponse.class);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String upload(byte[] data, UploadMetaData metaData) throws FlickrException, IOException, SAXException {
        Collection tags;
        String description;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("api_key", this.apiKey));
        String title = metaData.getTitle();
        if (title != null) {
            parameters.add(new Parameter("title", title));
        }
        if ((description = metaData.getDescription()) != null) {
            parameters.add(new Parameter("description", description));
        }
        if ((tags = metaData.getTags()) != null) {
            parameters.add(new Parameter("tags", StringUtilities.join(tags, " ")));
        }
        parameters.add(new Parameter("is_public", metaData.isPublicFlag() ? "1" : "0"));
        parameters.add(new Parameter("is_family", metaData.isFamilyFlag() ? "1" : "0"));
        parameters.add(new Parameter("is_friend", metaData.isFriendFlag() ? "1" : "0"));
        parameters.add(new Parameter("photo", data));
        if (metaData.isHidden() != null) {
            parameters.add(new Parameter("hidden", metaData.isHidden() != false ? "1" : "0"));
        }
        if (metaData.getSafetyLevel() != null) {
            parameters.add(new Parameter("safety_level", metaData.getSafetyLevel()));
        }
        parameters.add(new Parameter("async", metaData.isAsync() ? "1" : "0"));
        if (metaData.getContentType() != null) {
            parameters.add(new Parameter("content_type", metaData.getContentType()));
        }
        parameters.add(new Parameter("api_sig", AuthUtilities.getMultipartSignature(this.sharedSecret, parameters)));
        UploaderResponse response = (UploaderResponse)this.transport.post("/services/upload/", parameters, true);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        String id = "";
        id = metaData.isAsync() ? response.getTicketId() : response.getPhotoId();
        return id;
    }

    public String upload(InputStream in, UploadMetaData metaData) throws IOException, FlickrException, SAXException {
        Collection tags;
        String description;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("api_key", this.apiKey));
        String title = metaData.getTitle();
        if (title != null) {
            parameters.add(new Parameter("title", title));
        }
        if ((description = metaData.getDescription()) != null) {
            parameters.add(new Parameter("description", description));
        }
        if ((tags = metaData.getTags()) != null) {
            parameters.add(new Parameter("tags", StringUtilities.join(tags, " ")));
        }
        parameters.add(new Parameter("is_public", metaData.isPublicFlag() ? "1" : "0"));
        parameters.add(new Parameter("is_family", metaData.isFamilyFlag() ? "1" : "0"));
        parameters.add(new Parameter("is_friend", metaData.isFriendFlag() ? "1" : "0"));
        parameters.add(new Parameter("async", metaData.isAsync() ? "1" : "0"));
        parameters.add(new Parameter("photo", in));
        parameters.add(new Parameter("api_sig", AuthUtilities.getMultipartSignature(this.sharedSecret, parameters)));
        UploaderResponse response = (UploaderResponse)this.transport.post("/services/upload/", parameters, true);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        String id = "";
        id = metaData.isAsync() ? response.getTicketId() : response.getPhotoId();
        return id;
    }
}

