/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.places;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.AuthUtilities;
import com.aetrion.flickr.places.Location;
import com.aetrion.flickr.places.Place;
import com.aetrion.flickr.places.PlacesList;
import com.aetrion.flickr.util.XMLUtilities;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PlacesInterface {
    public static final String METHOD_FIND = "flickr.places.find";
    public static final String METHOD_FIND_BY_LATLON = "flickr.places.findByLatLon";
    public static final String METHOD_RESOLVE_PLACE_ID = "flickr.places.resolvePlaceId";
    public static final String METHOD_RESOLVE_PLACE_URL = "flickr.places.resolvePlaceURL";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public PlacesInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public PlacesList find(String query) throws FlickrException, IOException, SAXException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        PlacesList placesList = new PlacesList();
        parameters.add(new Parameter("method", METHOD_FIND));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("query", query));
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public PlacesList findByLatLon(double latitude, double longitude, int accuracy) throws FlickrException, IOException, SAXException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        PlacesList placesList = new PlacesList();
        parameters.add(new Parameter("method", METHOD_FIND_BY_LATLON));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("lat", "" + latitude));
        parameters.add(new Parameter("lon", "" + longitude));
        parameters.add(new Parameter("accuracy", "" + accuracy));
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public Location resolvePlaceId(String placeId) throws FlickrException, IOException, SAXException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_RESOLVE_PLACE_ID));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("place_id", placeId));
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element locationElement = response.getPayload();
        return this.parseLocation(locationElement);
    }

    public Location resolvePlaceURL(String flickrPlacesUrl) throws FlickrException, IOException, SAXException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_RESOLVE_PLACE_URL));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("url", flickrPlacesUrl));
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element locationElement = response.getPayload();
        return this.parseLocation(locationElement);
    }

    private Location parseLocation(Element locationElement) {
        Location location = new Location();
        Element localityElement = (Element)locationElement.getElementsByTagName("locality").item(0);
        Element countyElement = (Element)locationElement.getElementsByTagName("county").item(0);
        Element regionElement = (Element)locationElement.getElementsByTagName("region").item(0);
        Element countryElement = (Element)locationElement.getElementsByTagName("country").item(0);
        location.setPlaceId(locationElement.getAttribute("place_id"));
        location.setPlaceUrl(locationElement.getAttribute("place_url"));
        location.setWoeId(locationElement.getAttribute("woeid"));
        location.setLatitude(locationElement.getAttribute("latitude"));
        location.setLongitude(locationElement.getAttribute("longitude"));
        location.setPlaceType(this.determineType(locationElement.getAttribute("place_type")));
        location.setLocality(this.parseLocationPlace(localityElement, 1));
        location.setCounty(this.parseLocationPlace(countyElement, 2));
        location.setRegion(this.parseLocationPlace(regionElement, 3));
        location.setCountry(this.parseLocationPlace(countryElement, 4));
        return location;
    }

    private Place parseLocationPlace(Element element, int type) {
        Place place = new Place();
        place.setName(XMLUtilities.getValue(element));
        place.setPlaceId(element.getAttribute("place_id"));
        place.setPlaceUrl(element.getAttribute("place_url"));
        place.setWoeId(element.getAttribute("woeid"));
        place.setLatitude(element.getAttribute("latitude"));
        place.setLongitude(element.getAttribute("longitude"));
        place.setPlaceType(type);
        return place;
    }

    private Place parsePlace(Element placeElement) {
        Place place = new Place();
        place.setPlaceId(placeElement.getAttribute("place_id"));
        place.setPlaceUrl(placeElement.getAttribute("place_url"));
        place.setWoeId(placeElement.getAttribute("woeid"));
        place.setLatitude(placeElement.getAttribute("latitude"));
        place.setLongitude(placeElement.getAttribute("longitude"));
        String typeString = placeElement.getAttribute("place_type");
        place.setPlaceType(this.determineType(typeString));
        return place;
    }

    private int determineType(String typeString) {
        int placeType = 0;
        if (typeString.equals("locality")) {
            placeType = 1;
        } else if (typeString.equals("county")) {
            placeType = 2;
        } else if (typeString.equals("region")) {
            placeType = 3;
        } else if (typeString.equals("country")) {
            placeType = 4;
        }
        return placeType;
    }
}

