/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.sort;

import umontreal.ssj.util.sort.BatchSortPow2;
import umontreal.ssj.util.sort.HilbertCurveMap;
import umontreal.ssj.util.sort.HilbertCurveSort;
import umontreal.ssj.util.sort.MultiDimComparable;
import umontreal.ssj.util.sort.MultiDimSortComparable;

public class HilbertCurveBatchSort<T extends MultiDimComparable<? super T>>
implements MultiDimSortComparable<T> {
    int dimension;
    int m;
    HilbertCurveMap hcMap;
    BatchSortPow2 bsort;
    long[][] indexH;
    int nSavedIndex = 0;

    public HilbertCurveBatchSort(double[] batchExponents, int m) {
        this.hcMap = new HilbertCurveMap(batchExponents.length, m);
        this.dimension = batchExponents.length;
        this.m = m;
        this.bsort = new BatchSortPow2(batchExponents);
    }

    public HilbertCurveBatchSort(double[] batchExponents, int m, HilbertCurveMap map) {
        this.dimension = batchExponents.length;
        this.m = m;
        if (map.dimension() != this.dimension) {
            throw new IllegalArgumentException("HilbertCurveMap has a different dimension! Expecting: " + this.dimension);
        }
        this.hcMap = map;
        this.bsort = new BatchSortPow2(batchExponents);
    }

    public void computeIndexH(int n) {
        if (n == this.nSavedIndex) {
            return;
        }
        this.nSavedIndex = n;
        this.indexH = new long[n][2];
        int twom = 1 << this.m;
        int mdim = this.dimension - 1;
        int[] ej = this.bsort.getBitNumbers();
        int[] stepj = new int[this.dimension];
        int[] icoord = new int[this.dimension];
        for (int j = 0; j < this.dimension; ++j) {
            if (ej[j] > this.m) {
                throw new RuntimeException("ej[j] is larger than m");
            }
            icoord[j] = 0;
            stepj[j] = 1 << this.m - ej[j];
        }
        this.indexH[0][0] = 0L;
        this.indexH[0][1] = 0L;
        for (int i = 1; i < n; ++i) {
            int n2 = mdim;
            icoord[n2] = icoord[n2] + stepj[mdim];
            if (icoord[mdim] == twom) {
                for (int j = mdim; j >= 0 && icoord[j] >= twom; --j) {
                    icoord[j] = 0;
                    int n3 = j - 1;
                    icoord[n3] = icoord[n3] + 1;
                }
            }
            this.indexH[i][0] = i;
            this.indexH[i][1] = this.hcMap.coordinatesToIndex(icoord);
        }
        HilbertCurveSort.sortIndexOfLong2(this.indexH, 0, n);
    }

    @Override
    public void sort(T[] a, int iMin, int iMax) {
        if (iMin + 1 == iMax) {
            return;
        }
        if (iMax - iMin != this.nSavedIndex) {
            this.computeIndexH(iMax - iMin);
        }
        this.bsort.sort((MultiDimComparable[])a, iMin, iMax);
        MultiDimComparable[] aclone = (MultiDimComparable[])a.clone();
        for (int i = iMin; i < iMax; ++i) {
            a[i] = aclone[(int)this.indexH[i][0]];
        }
    }

    @Override
    public void sort(T[] a) {
        this.sort((MultiDimComparable[])a, 0, a.length);
    }

    @Override
    public void sort(double[][] a, int iMin, int iMax) {
        if (iMin + 1 == iMax) {
            return;
        }
        if (iMax - iMin != this.nSavedIndex) {
            this.computeIndexH(iMax - iMin);
        }
        this.bsort.sort(a, iMin, iMax);
        double[][] aclone = (double[][])a.clone();
        for (int i = iMin; i < iMax; ++i) {
            a[i] = aclone[(int)this.indexH[i][0]];
        }
    }

    @Override
    public void sort(double[][] a) {
        this.sort(a, 0, a.length);
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    public HilbertCurveMap getHilbertCurveMap() {
        return this.hcMap;
    }
}

