/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.matrix;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import umontreal.ssj.stat.FunctionOfMultipleMeansTally;
import umontreal.ssj.stat.matrix.MatrixOfStatProbes;
import umontreal.ssj.util.MultivariateFunction;

public class MatrixOfFunctionOfMultipleMeansTallies<E extends FunctionOfMultipleMeansTally>
extends MatrixOfStatProbes<E> {
    double[][][] temp;

    public MatrixOfFunctionOfMultipleMeansTallies(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public MatrixOfFunctionOfMultipleMeansTallies(String name, int numRows, int numColumns) {
        super(name, numRows, numColumns);
    }

    public static MatrixOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally> create(MultivariateFunction func, int d, int numRows, int numColumns) {
        MatrixOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally> matrix = new MatrixOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally>(numRows, numColumns);
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numColumns; ++c) {
                matrix.set(r, c, new FunctionOfMultipleMeansTally(func, d));
            }
        }
        return matrix;
    }

    public void add(double[][][] x) {
        if (x.length != this.rows()) {
            throw new IllegalArgumentException("The length of the given array must correspond to the number of rows in the matrix");
        }
        if (this.collect) {
            for (int i = 0; i < x.length; ++i) {
                if (x[i].length != this.columns()) {
                    throw new IllegalArgumentException("The length of the array x[" + i + "] must correspond to the number of columns in the matrix");
                }
                for (int j = 0; j < x[i].length; ++j) {
                    ((FunctionOfMultipleMeansTally)this.get(i, j)).add(x[i][j]);
                }
            }
        }
    }

    public void add(DoubleMatrix3D x) {
        if (x.rows() != this.rows()) {
            throw new IllegalArgumentException("The number of rows of the given matrix must correspond to the number of rows in the matrix of probes");
        }
        if (x.columns() != this.columns()) {
            throw new IllegalArgumentException("The number of columns of the given matrix must correspond to the number of columns in the matrix of probes");
        }
        if (this.collect) {
            for (int i = 0; i < this.rows(); ++i) {
                for (int j = 0; j < x.columns(); ++j) {
                    ((FunctionOfMultipleMeansTally)this.get(i, j)).add(x.viewSlice(i).viewRow(j).toArray());
                }
            }
        }
    }

    public void addSameDimension(DoubleMatrix2D ... x) {
        int nr = this.rows();
        int nc = this.columns();
        int d = this.getDimension();
        if (x.length != d) {
            throw new IllegalArgumentException("The length of the given array must be " + d + " while its actual length is " + x.length);
        }
        if (x.length == 0 || nr == 0 || nc == 0) {
            return;
        }
        if (nr != x[0].rows() || nc != x[0].columns()) {
            throw new IllegalArgumentException("The given matrices must have the same dimensions");
        }
        for (int i = 0; i < x.length - 1; ++i) {
            if (x[i].rows() == x[i + 1].rows() && x[i].columns() == x[i + 1].columns()) continue;
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        if (this.temp == null || this.temp.length != nr || this.temp[0].length != nc || this.temp[0][0].length != d) {
            this.temp = new double[nr][nc][d];
        }
        for (int r = 0; r < nr; ++r) {
            for (int c = 0; c < nc; ++c) {
                for (int j = 0; j < d; ++j) {
                    this.temp[r][c][j] = x[j].getQuick(r, c);
                }
            }
        }
        this.add(this.temp);
    }

    public int getDimension() {
        if (this.rows() == 0 || this.columns() == 0) {
            return 0;
        }
        FunctionOfMultipleMeansTally t0 = (FunctionOfMultipleMeansTally)this.get(0, 0);
        return t0 == null ? 0 : t0.getDimension();
    }

    public int numberObs() {
        if (this.rows() == 0 || this.columns() == 0) {
            return 0;
        }
        FunctionOfMultipleMeansTally t0 = (FunctionOfMultipleMeansTally)this.get(0, 0);
        return t0 == null ? 0 : t0.numberObs();
    }

    public boolean areAllNumberObsEqual() {
        int nr = this.rows();
        int nc = this.columns();
        int n = this.numberObs();
        for (int r = 0; r < nr; ++r) {
            for (int c = 0; c < nc; ++c) {
                FunctionOfMultipleMeansTally t = (FunctionOfMultipleMeansTally)this.get(r, c);
                if (t.numberObs() == n) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void average(DoubleMatrix2D m) {
        super.average(m);
        for (int i = 0; i < m.rows(); ++i) {
            for (int j = 0; j < m.columns(); ++j) {
                if (Double.isNaN(m.getQuick(i, j)) || ((FunctionOfMultipleMeansTally)this.get(i, j)).numberObs() != 0) continue;
                m.setQuick(i, j, Double.NaN);
            }
        }
    }

    public void variance(DoubleMatrix2D m) {
        if (m.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + m.rows());
        }
        if (m.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + m.columns());
        }
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                FunctionOfMultipleMeansTally tally = (FunctionOfMultipleMeansTally)this.get(r, c);
                m.setQuick(r, c, tally != null && tally.numberObs() >= 2 ? tally.variance() : Double.NaN);
            }
        }
    }

    public void standardDeviation(DoubleMatrix2D m) {
        if (m.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + m.rows());
        }
        if (m.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + m.columns());
        }
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                FunctionOfMultipleMeansTally tally = (FunctionOfMultipleMeansTally)this.get(r, c);
                m.setQuick(r, c, tally != null && tally.numberObs() >= 2 ? tally.standardDeviation() : Double.NaN);
            }
        }
    }

    @Override
    public MatrixOfFunctionOfMultipleMeansTallies<E> clone() {
        MatrixOfFunctionOfMultipleMeansTallies clone = (MatrixOfFunctionOfMultipleMeansTallies)super.clone();
        if (this.temp != null) {
            clone.temp = new double[this.temp.length][this.temp[0].length][this.temp[0].length];
            for (int i = 0; i < this.temp.length; ++i) {
                int j = 0;
                while (j < this.temp[i].length) {
                    for (int k = 0; k < this.temp[i][j].length; ++k) {
                        clone.temp[i][j][k] = this.temp[i][j][k];
                    }
                    ++i;
                }
            }
        }
        return clone;
    }
}

