/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simexp;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import java.lang.ref.SoftReference;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.Simulator;
import umontreal.ssj.simexp.SimExp;
import umontreal.ssj.util.Misc;

public abstract class BatchMeansSim
extends SimExp {
    private DoubleArrayList batchTimes = new DoubleArrayList();
    private boolean batchLengths;
    private boolean aggregation;
    private int minBatches;
    private int maxBatches;
    private double warmupTime;
    private EndSimEvent endSimEvent;
    private boolean warmupDone;
    private int targetBatches;
    private int doneBatches;
    private int droppedBatches;
    private double batchFraction;
    private double batchSizeMultiplier;
    private boolean aggregateUpdated;
    private double batchSize;
    private int nAgr;

    public BatchMeansSim(int minBatches, double batchSize, double warmupTime) {
        this(minBatches, Integer.MAX_VALUE, batchSize, warmupTime);
    }

    public BatchMeansSim(int minBatches, int maxBatches, double batchSize, double warmupTime) {
        this(Simulator.getDefaultSimulator(), minBatches, maxBatches, batchSize, warmupTime);
    }

    public BatchMeansSim(Simulator sim, int minBatches, double batchSize, double warmupTime) {
        this(sim, minBatches, Integer.MAX_VALUE, batchSize, warmupTime);
    }

    public BatchMeansSim(Simulator sim, int minBatches, int maxBatches, double batchSize, double warmupTime) {
        super(sim);
        if (minBatches <= 0) {
            throw new IllegalArgumentException("minBatches <= 0");
        }
        if (maxBatches < minBatches) {
            throw new IllegalArgumentException("maxBatches < minBatches");
        }
        if (warmupTime < 0.0) {
            throw new IllegalArgumentException("Warmup time must not be negative");
        }
        if (batchSize <= 0.0) {
            throw new IllegalArgumentException("Batch size must not be 0 or negative");
        }
        this.minBatches = minBatches;
        this.maxBatches = maxBatches;
        this.warmupTime = warmupTime;
        this.batchSize = batchSize;
        this.targetBatches = minBatches;
    }

    public boolean getBatchAggregation() {
        return this.aggregation;
    }

    public void setBatchAggregation(boolean a) {
        if (this.warmupDone && this.simulating) {
            throw new IllegalStateException("Cannot change the aggregation status during simulation");
        }
        this.aggregation = a;
    }

    public boolean getBatchLengthsKeeping() {
        return this.batchLengths;
    }

    public void setBatchLengthsKeeping(boolean b) {
        if (this.warmupDone && this.simulating) {
            throw new IllegalStateException("Cannot change the aggregation status during simulation");
        }
        this.batchLengths = b;
    }

    public int getMinBatches() {
        return this.minBatches;
    }

    public void setMinBatches(int minBatches) {
        if (minBatches <= 0) {
            throw new IllegalArgumentException("minBatches <= 0");
        }
        this.minBatches = minBatches;
        if (this.maxBatches < minBatches) {
            this.maxBatches = minBatches;
        }
    }

    public int getMaxBatches() {
        return this.maxBatches;
    }

    public void setMaxBatches(int maxBatches) {
        if (maxBatches < this.minBatches) {
            throw new IllegalArgumentException("maxBatches < minBatches");
        }
        this.maxBatches = maxBatches;
    }

    public double getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(double batchSize) {
        if (batchSize <= 0.0) {
            throw new IllegalArgumentException("batchSize <= 0");
        }
        this.batchSize = batchSize;
    }

    public double getWarmupTime() {
        return this.warmupTime;
    }

    public void setWarmupTime(double warmupTime) {
        if (warmupTime < 0.0) {
            throw new IllegalArgumentException("warmupTime < 0");
        }
        this.warmupTime = warmupTime;
    }

    public double getBatchFraction() {
        return this.batchFraction;
    }

    public double getBatchSizeMultiplier() {
        return this.batchSizeMultiplier;
    }

    public int getTargetBatches() {
        return this.targetBatches;
    }

    public void setTargetBatches(int targetBatches) {
        if (targetBatches < this.minBatches) {
            throw new IllegalArgumentException("Target number of batches too small");
        }
        if (targetBatches > this.maxBatches) {
            throw new IllegalArgumentException("Target number of batches too large");
        }
        this.targetBatches = targetBatches;
    }

    public int getCompletedRealBatches() {
        return this.doneBatches;
    }

    public int getDroppedRealBatches() {
        return this.droppedBatches;
    }

    public void dropFirstRealBatches(int n) {
        if (n < 0 || n > this.doneBatches - this.droppedBatches) {
            throw new IllegalArgumentException("Cannot drop less than 0 or more than " + (this.doneBatches - this.droppedBatches) + " real batches");
        }
        if (this.batchLengths || this.aggregation) {
            this.batchTimes.removeFromTo(0, n - 1);
        }
        this.droppedBatches += n;
    }

    public int getBatch(double time) {
        if (!this.warmupDone) {
            return -1;
        }
        if (!this.batchLengths && !this.aggregation) {
            return -1;
        }
        if (this.batchTimes.size() == 0) {
            return -1;
        }
        return Misc.getTimeInterval(this.batchTimes.elements(), 0, this.doneBatches, time);
    }

    public boolean isWarmupDone() {
        return this.warmupDone;
    }

    public int getNumAggregates() {
        if (this.nAgr == 0) {
            throw new IllegalStateException("Number of real batches not available");
        }
        return this.nAgr;
    }

    public double getRealBatchLength(int batch) {
        if (this.batchLengths || this.aggregation) {
            return this.batchTimes.get(batch + 1 - this.droppedBatches) - this.batchTimes.getQuick(batch - this.droppedBatches);
        }
        if (batch != this.doneBatches - 1) {
            throw new IllegalArgumentException("Unavailable batch length");
        }
        return this.batchTimes.getQuick(1) - this.batchTimes.getQuick(0);
    }

    public double getRealBatchStartingTime(int batch) {
        if (this.batchLengths || this.aggregation) {
            return this.batchTimes.get(batch);
        }
        if (batch != this.doneBatches - 1) {
            throw new IllegalArgumentException("Unavailable batch time");
        }
        return this.batchTimes.getQuick(0);
    }

    public double getRealBatchEndingTime(int batch) {
        if (this.batchLengths || this.aggregation) {
            return this.batchTimes.get(batch + 1);
        }
        if (batch != this.doneBatches - 1) {
            throw new IllegalArgumentException("Unavailable batch time");
        }
        return this.batchTimes.getQuick(1);
    }

    public void allocateCapacity(int capacity) {
        throw new UnsupportedOperationException();
    }

    public void regroupRealBatches(int x) {
        throw new UnsupportedOperationException();
    }

    private final void allocateCapacity() {
        SoftReference<double[]> softRef = new SoftReference<double[]>(new double[50000]);
        this.batchFraction = 1.0;
        this.batchSizeMultiplier = 1.0;
        int currentCapacity = this.doneBatches;
        while (currentCapacity < this.targetBatches && softRef.get() != null) {
            int newCapacity = Math.min(2 * currentCapacity + 1, this.targetBatches);
            if (this.aggregation || this.batchLengths) {
                this.batchTimes.ensureCapacity(newCapacity + 1);
            }
            try {
                this.allocateCapacity(newCapacity);
            }
            catch (UnsupportedOperationException use) {
                return;
            }
            currentCapacity = newCapacity;
        }
        if (currentCapacity < this.targetBatches && softRef.get() == null) {
            if (!this.aggregation) {
                throw new IllegalStateException("Cannot increase batch size");
            }
            double ftargetBatches = this.targetBatches;
            double fdoneBatches = this.doneBatches;
            while (this.targetBatches > currentCapacity) {
                this.batchSizeMultiplier *= 2.0;
                this.targetBatches = (int)(ftargetBatches /= 2.0);
                this.doneBatches = (int)(fdoneBatches /= 2.0);
                if (this.aggregation || this.batchLengths) {
                    for (int i = 0; i < this.batchTimes.size() / 2; ++i) {
                        this.batchTimes.setQuick(i, this.batchTimes.getQuick(2 * i));
                    }
                    this.batchTimes.setSize(this.batchTimes.size() / 2);
                }
                this.regroupRealBatches(2);
                this.batchFraction = 1.0 - (fdoneBatches - (double)this.doneBatches);
            }
            if (this.targetBatches % this.minBatches != 0) {
                this.targetBatches /= this.minBatches;
                this.targetBatches *= this.minBatches;
                this.targetBatches += this.minBatches;
            }
        }
    }

    public abstract void initSimulation();

    public abstract void initBatchStat();

    public abstract void initRealBatchProbes();

    public abstract void initEffectiveBatchProbes();

    public abstract void addRealBatchObs();

    public abstract void addEffectiveBatchObs(int var1, int var2, double var3);

    public int getRequiredNewBatches() {
        return 0;
    }

    public void init() {
        if (this.simulating) {
            throw new IllegalStateException("Already simulating");
        }
        this.nAgr = 0;
        this.warmupDone = false;
        this.doneBatches = 0;
        this.droppedBatches = 0;
        if (this.targetBatches < this.minBatches) {
            this.targetBatches = this.minBatches;
        }
        if (this.aggregation && this.targetBatches % this.minBatches != 0) {
            this.targetBatches /= this.minBatches;
            this.targetBatches += this.minBatches;
            if (this.targetBatches + this.minBatches <= this.maxBatches) {
                this.targetBatches += this.minBatches;
            }
        }
        this.aggregateUpdated = false;
        this.simulator().init();
        this.endSimEvent = new EndSimEvent(this.simulator());
        this.initSimulation();
    }

    public Event getEndSimEvent() {
        return this.endSimEvent;
    }

    public void warmup() {
        this.warmup(this.warmupTime);
    }

    public void warmup(double warmupTime) {
        if (this.warmupDone) {
            throw new IllegalStateException("Warmup already done");
        }
        if (!Double.isInfinite(warmupTime) && !Double.isNaN(warmupTime)) {
            this.endSimEvent.schedule(warmupTime);
        }
        this.simulator().start();
        this.endSimEvent.cancel();
        this.initRealBatchProbes();
        if (!this.aggregation) {
            this.initEffectiveBatchProbes();
        }
        if (this.aggregation || this.batchLengths) {
            this.batchTimes.setSize(0);
            this.batchTimes.add(this.simulator().time());
        } else {
            this.batchTimes.setSize(2);
            this.batchTimes.trimToSize();
            this.batchTimes.setQuick(0, this.simulator().time());
            this.batchTimes.setQuick(1, this.simulator().time());
        }
        this.warmupDone = true;
    }

    public void simulateBatch() {
        double f = this.getBatchSizeMultiplier();
        if (f > 1.0) {
            this.batchSize *= f;
        }
        this.simulateBatch(this.batchSize * this.getBatchFraction());
    }

    public void simulateBatch(double batchLength) {
        this.initBatchStat();
        this.endSimEvent.schedule(batchLength);
        this.simulator().start();
        this.endSimEvent.cancel();
        this.batchFraction = 1.0;
        this.batchSizeMultiplier = 1.0;
        this.aggregateUpdated = false;
        ++this.doneBatches;
        if (this.batchLengths || this.aggregation) {
            this.batchTimes.add(this.simulator().time());
        } else {
            this.batchTimes.setQuick(0, this.batchTimes.getQuick(1));
            this.batchTimes.setQuick(1, this.simulator().time());
        }
        this.addRealBatchObs();
        if (!this.aggregation) {
            this.nAgr = 1;
            this.addEffectiveBatchObs(this.doneBatches - 1, 1, this.getRealBatchLength(this.doneBatches - 1));
        }
    }

    public void adjustTargetBatches(int numNewBatches) {
        if (this.doneBatches + numNewBatches > this.maxBatches) {
            numNewBatches = this.maxBatches - this.doneBatches;
            if (this.aggregation && numNewBatches < this.minBatches) {
                return;
            }
        }
        if (this.aggregation && numNewBatches % this.minBatches != 0) {
            numNewBatches /= this.minBatches;
            if (this.doneBatches + (numNewBatches *= this.minBatches) + this.minBatches <= this.maxBatches) {
                numNewBatches += this.minBatches;
            }
        }
        this.targetBatches = this.doneBatches + numNewBatches;
    }

    public void simulateBatches() {
        if (this.doneBatches < this.targetBatches) {
            this.allocateCapacity();
        }
        while (this.doneBatches < this.targetBatches) {
            this.simulateBatch();
        }
        if (this.aggregation) {
            this.makeAggregateBatches();
        }
    }

    @Override
    public void simulate() {
        this.init();
        this.simulating = true;
        try {
            this.warmup(this.warmupTime);
            while (this.doneBatches < this.targetBatches) {
                this.simulateBatches();
                this.adjustTargetBatches(this.getRequiredNewBatches());
            }
            if (this.aggregation && !this.aggregateUpdated) {
                this.makeAggregateBatches();
            }
        }
        finally {
            this.simulating = false;
        }
    }

    private final void makeAggregateBatches() {
        this.initEffectiveBatchProbes();
        this.nAgr = (this.doneBatches - this.droppedBatches) / this.minBatches;
        int tnb = this.minBatches;
        if (this.nAgr == 0) {
            this.nAgr = 1;
            tnb = this.doneBatches - this.droppedBatches;
        }
        for (int i = 0; i < tnb; ++i) {
            int startAgr = i * this.nAgr + this.droppedBatches;
            this.addEffectiveBatchObs(startAgr, this.nAgr, this.batchTimes.getQuick(startAgr - this.droppedBatches + this.nAgr) - this.batchTimes.getQuick(startAgr - this.droppedBatches));
        }
        this.aggregateUpdated = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append('[');
        sb.append("minimal number of batches: ").append(this.minBatches);
        if (this.maxBatches < Integer.MAX_VALUE) {
            sb.append(", maximal number of batches: ").append(this.maxBatches);
        }
        sb.append(", target number of batches: ").append(this.targetBatches);
        sb.append(", warmup time: ").append(this.warmupTime);
        if (this.simulating) {
            sb.append(", simulation in progress");
        } else {
            sb.append(", simulation stopped");
        }
        if (this.warmupDone) {
            sb.append(", number of completed batches: ").append(this.doneBatches);
        } else {
            sb.append(", warmup not completed");
        }
        if (this.aggregation) {
            sb.append(", batch aggregation turned ON");
        } else {
            sb.append(", batch aggregation turned OFF");
            if (this.batchLengths) {
                sb.append(", batch lengths are kept");
            } else {
                sb.append(", batch lengths are not kept");
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public static double getSum(double[] a, int start, int length) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start must not be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (start + length > a.length) {
            throw new IndexOutOfBoundsException("Not enough elements in the array");
        }
        double s = 0.0;
        for (int i = start; i < start + length; ++i) {
            s += a[i];
        }
        return s;
    }

    public static double getSum(DoubleArrayList l, int start, int length) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start must not be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (start + length > l.size()) {
            throw new IndexOutOfBoundsException("Not enough elements in the array list");
        }
        double s = 0.0;
        for (int i = start; i < start + length; ++i) {
            s += l.getQuick(i);
        }
        return s;
    }

    public static double getSum(DoubleMatrix1D m, int start, int length) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start must not be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (start + length > m.size()) {
            throw new IndexOutOfBoundsException("Not enough elements in the matrix");
        }
        double s = 0.0;
        for (int i = start; i < start + length; ++i) {
            s += m.getQuick(i);
        }
        return s;
    }

    public static double[] getSum(double[][] a, int startColumn, int numColumns) {
        if (a.length == 0) {
            return new double[0];
        }
        if (startColumn < 0) {
            throw new IndexOutOfBoundsException("startColumn must not be negative");
        }
        if (numColumns < 0) {
            throw new IllegalArgumentException("numColumns is negative");
        }
        if (startColumn + numColumns > a[0].length) {
            throw new IndexOutOfBoundsException("Not enough elements in the array");
        }
        double[] res = new double[a.length];
        for (int i = 0; i < res.length; ++i) {
            for (int j = startColumn; j < startColumn + numColumns; ++j) {
                int n = i;
                res[n] = res[n] + a[i][j];
            }
        }
        return res;
    }

    public static double[] getSum(DoubleMatrix2D m, int startColumn, int numColumns) {
        if (startColumn < 0) {
            throw new IndexOutOfBoundsException("startColumn must not be negative");
        }
        if (numColumns < 0) {
            throw new IllegalArgumentException("numColumns is negative");
        }
        if (startColumn + numColumns > m.columns()) {
            throw new IndexOutOfBoundsException("Not enough columns in the matrix");
        }
        double[] res = new double[m.rows()];
        for (int i = 0; i < res.length; ++i) {
            for (int j = startColumn; j < startColumn + numColumns; ++j) {
                int n = i;
                res[n] = res[n] + m.getQuick(i, j);
            }
        }
        return res;
    }

    public static void regroupElements(double[] a, int x) {
        double o;
        if (x < 1) {
            throw new IllegalArgumentException("x < 1");
        }
        int gs = a.length / x;
        for (int i = 0; i < gs; ++i) {
            o = 0.0;
            for (int j = 0; j < x; ++j) {
                o += a[i * x + j];
            }
            a[i] = o;
        }
        int m = a.length % x;
        if (m > 0) {
            o = 0.0;
            int r = a.length - x * gs;
            for (int j = 0; j < r; ++j) {
                o += a[gs * x + j];
            }
            a[gs] = o;
            ++gs;
        }
        for (int i = gs; i < a.length; ++i) {
            a[i] = 0.0;
        }
    }

    public static void regroupElements(DoubleArrayList l, int x) {
        double o;
        if (x < 1) {
            throw new IllegalArgumentException("x < 1");
        }
        int gs = l.size() / x;
        for (int i = 0; i < gs; ++i) {
            o = 0.0;
            for (int j = 0; j < x; ++j) {
                o += l.getQuick(i * x + j);
            }
            l.setQuick(i, o);
        }
        int m = l.size() % x;
        if (m > 0) {
            o = 0.0;
            int r = l.size() - x * gs;
            for (int j = 0; j < r; ++j) {
                o += l.getQuick(gs * x + j);
            }
            l.setQuick(gs, o);
            ++gs;
        }
        l.setSize(gs);
    }

    public static void regroupElements(DoubleMatrix1D mat, int x) {
        double o;
        if (x < 1) {
            throw new IllegalArgumentException("x < 1");
        }
        int gs = mat.size() / x;
        for (int i = 0; i < gs; ++i) {
            o = 0.0;
            for (int j = 0; j < x; ++j) {
                o += mat.getQuick(i * x + j);
            }
            mat.setQuick(i, o);
        }
        int m = mat.size() % x;
        if (m > 0) {
            o = 0.0;
            int r = mat.size() - x * gs;
            for (int j = 0; j < r; ++j) {
                o += mat.getQuick(gs * x + j);
            }
            mat.setQuick(gs, o);
            ++gs;
        }
        for (int i = gs; i < mat.size(); ++i) {
            mat.setQuick(i, 0.0);
        }
    }

    public static void regroupElements(DoubleMatrix2D mat, int x) {
        int r;
        if (x < 1) {
            throw new IllegalArgumentException("x < 1");
        }
        int gs = mat.columns() / x;
        for (int i = 0; i < gs; ++i) {
            for (r = 0; r < mat.rows(); ++r) {
                double o = 0.0;
                for (int j = 0; j < x; ++j) {
                    o += mat.getQuick(r, i * x + j);
                }
                mat.setQuick(r, i, o);
            }
        }
        int m = mat.columns() % x;
        if (m > 0) {
            r = mat.columns() - x * gs;
            for (int row = 0; row < mat.rows(); ++row) {
                double o = 0.0;
                for (int j = 0; j < r; ++j) {
                    o += mat.getQuick(row, gs * x + j);
                }
                mat.setQuick(row, gs, o);
            }
            ++gs;
        }
        for (int row = 0; row < mat.rows(); ++row) {
            for (int i = gs; i < mat.columns(); ++i) {
                mat.setQuick(row, i, 0.0);
            }
        }
    }

    private static final class EndSimEvent
    extends Event {
        public EndSimEvent(Simulator sim) {
            super(sim);
        }

        @Override
        public void actions() {
            this.simulator().stop();
        }
    }
}

