/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simevents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import umontreal.ssj.simevents.Continuous;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.Simulator;

public class ContinuousState {
    private double stepSize;
    private IntegMethod integMethod;
    private int order;
    private double[] A = new double[4];
    private double[] B = new double[4];
    private double[] C = new double[4];
    private StepEvent stepEv = null;
    private List<Continuous> list = new ArrayList<Continuous>();
    private Simulator sim;

    protected ContinuousState(Simulator sim) {
        this.sim = sim;
        assert (sim != null);
    }

    public List<Continuous> getContinuousVariables() {
        return Collections.unmodifiableList(this.list);
    }

    protected void startInteg(Continuous c) {
        if (this.stepEv == null) {
            this.stepEv = new StepEvent(this.sim);
        }
        c.active = true;
        if (this.list.isEmpty()) {
            this.stepEv.schedule(this.stepSize);
        }
        this.list.add(c);
    }

    protected void stopInteg(Continuous c) {
        c.active = false;
        this.list.remove(c);
        if (this.list.isEmpty()) {
            this.stepEv.cancel();
        }
    }

    public IntegMethod integMethod() {
        return this.integMethod;
    }

    public void selectEuler(double h) {
        this.integMethod = IntegMethod.EULER;
        this.stepSize = h;
    }

    public void selectRungeKutta2(double h) {
        this.integMethod = IntegMethod.RUNGEKUTTA2;
        this.stepSize = h;
        this.order = 2;
        this.A[0] = 1.0;
        this.A[1] = 0.0;
        this.B[0] = 0.5;
        this.B[1] = 0.5;
        this.C[0] = 0.0;
        this.C[1] = 1.0;
    }

    public void selectRungeKutta4(double h) {
        this.integMethod = IntegMethod.RUNGEKUTTA4;
        this.stepSize = h;
        this.order = 4;
        this.A[0] = 0.5;
        this.A[1] = 0.5;
        this.A[2] = 1.0;
        this.A[3] = 0.0;
        this.B[0] = 0.16666666666666666;
        this.B[1] = 0.3333333333333333;
        this.B[2] = 0.3333333333333333;
        this.B[3] = 0.16666666666666666;
        this.C[0] = 0.0;
        this.C[1] = 0.5;
        this.C[2] = 0.5;
        this.C[3] = 1.0;
    }

    private void oneStepEuler() {
        Continuous v;
        double t = this.sim.time() - this.stepSize;
        int current = this.list.size();
        while (current > 0) {
            v = this.list.get(--current);
            v.phi = v.value + this.stepSize * v.derivative(t);
        }
        current = this.list.size();
        while (current > 0) {
            v = this.list.get(--current);
            v.value = v.phi;
            if (v.ev != null) {
                v.ev.scheduleNext();
            }
            v.afterEachStep();
        }
    }

    private void oneStepRK() {
        Continuous v;
        double t = this.sim.time() - this.stepSize;
        int current = this.list.size();
        while (current > 0) {
            v = this.list.get(--current);
            v.buffer = v.value;
            v.sum = 0.0;
            v.pi = 0.0;
        }
        for (int i = 1; i <= this.order - 1; ++i) {
            current = this.list.size();
            while (current > 0) {
                v = this.list.get(--current);
                v.pi = v.derivative(t + this.stepSize * this.C[i - 1]);
                v.sum += v.pi * this.B[i - 1];
                v.phi = v.buffer + this.stepSize * v.pi * this.A[i - 1];
            }
            current = this.list.size();
            while (current > 0) {
                v = this.list.get(--current);
                v.value = v.phi;
            }
        }
        current = this.list.size();
        while (current > 0) {
            v = this.list.get(--current);
            v.pi = v.derivative(t + this.stepSize * this.C[this.order - 1]);
            v.value = v.buffer + this.stepSize * (v.sum + v.pi * this.B[this.order - 1]);
            if (v.ev != null) {
                v.ev.scheduleNext();
            }
            v.afterEachStep();
        }
    }

    private class StepEvent
    extends Event {
        public StepEvent(Simulator sim) {
            super(sim);
        }

        @Override
        public void actions() {
            switch (ContinuousState.this.integMethod) {
                case EULER: {
                    ContinuousState.this.oneStepEuler();
                    break;
                }
                case RUNGEKUTTA2: {
                    ContinuousState.this.oneStepRK();
                    break;
                }
                case RUNGEKUTTA4: {
                    ContinuousState.this.oneStepRK();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Integration step with undefined method");
                }
            }
            this.schedule(ContinuousState.this.stepSize);
        }

        public String toString() {
            return "Integration step for continuous variable ";
        }
    }

    public static enum IntegMethod {
        EULER,
        RUNGEKUTTA2,
        RUNGEKUTTA4;

    }
}

