/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.DiscreteDistribution;
import umontreal.ssj.probdist.Distribution;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class MixtureGen
extends RandomVariateGen {
    protected Distribution[] dists;
    protected DiscreteDistribution weightsDist;
    protected double[] weights;

    public MixtureGen(RandomStream s, Distribution[] dists, double[] weights) {
        super(s, null);
        if (dists.length != weights.length) {
            throw new IllegalArgumentException("The arrays dists and weigths must have the same length");
        }
        this.dists = dists;
        this.weights = weights;
        this.initWeightDistribution();
    }

    private void initWeightDistribution() {
        int[] idx = new int[this.weights.length];
        for (int i = 0; i < idx.length; ++i) {
            idx[i] = i;
        }
        this.weightsDist = new DiscreteDistribution(idx, this.weights, idx.length);
    }

    @Override
    public Distribution getDistribution() {
        throw new UnsupportedOperationException("Use getDistributions method instead");
    }

    public Distribution[] getDistributions() {
        return this.dists;
    }

    public double[] getWeights() {
        return this.weights;
    }

    @Override
    public double nextDouble() {
        int idx = (int)Math.round(this.weightsDist.inverseF(this.stream.nextDouble()));
        return this.dists[idx].inverseF(this.stream.nextDouble());
    }
}

