/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.GammaDist;
import umontreal.ssj.randvar.GammaGen;
import umontreal.ssj.rng.RandomStream;

public class GammaRejectionLoglogisticGen
extends GammaGen {
    private RandomStream auxStream;
    private double beta;
    private double gamma;
    private double aa;
    private double bb;
    private double cc;

    public GammaRejectionLoglogisticGen(RandomStream s, RandomStream aux, double alpha, double lambda) {
        super(s, null);
        this.auxStream = aux;
        this.setParams(alpha, lambda);
        this.beta = 1.0 / lambda;
        this.gamma = 0.0;
        this.init();
    }

    public GammaRejectionLoglogisticGen(RandomStream s, double alpha, double lambda) {
        this(s, s, alpha, lambda);
    }

    public GammaRejectionLoglogisticGen(RandomStream s, RandomStream aux, GammaDist dist) {
        super(s, dist);
        this.auxStream = aux;
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getLambda());
        }
        this.beta = 1.0 / dist.getLambda();
        this.gamma = 0.0;
        this.init();
    }

    public GammaRejectionLoglogisticGen(RandomStream s, GammaDist dist) {
        this(s, s, dist);
    }

    public RandomStream getAuxStream() {
        return this.auxStream;
    }

    @Override
    public double nextDouble() {
        return GammaRejectionLoglogisticGen.rejectionLogLogistic(this.stream, this.auxStream, this.alpha, this.beta, this.gamma, this.aa, this.bb, this.cc);
    }

    public static double nextDouble(RandomStream s, RandomStream aux, double alpha, double lambda) {
        double aa = alpha > 1.0 ? Math.sqrt(alpha + alpha - 1.0) : alpha;
        double bb = alpha - 1.386294361;
        double cc = alpha + aa;
        return GammaRejectionLoglogisticGen.rejectionLogLogistic(s, aux, alpha, 1.0 / lambda, 0.0, aa, bb, cc);
    }

    public static double nextDouble(RandomStream s, double alpha, double lambda) {
        return GammaRejectionLoglogisticGen.nextDouble(s, s, alpha, lambda);
    }

    private static double rejectionLogLogistic(RandomStream stream, RandomStream auxStream, double alpha, double beta, double gamma, double aa, double bb, double cc) {
        double u2;
        double z;
        double X;
        double u1;
        double v;
        double r;
        do {
            u1 = stream.nextDouble();
            u2 = stream.nextDouble();
            stream = auxStream;
        } while (!((r = bb + cc * (v = Math.log(u1 / (1.0 - u1)) / aa) - (X = alpha * Math.exp(v))) + 2.504077397 >= 4.5 * (z = u1 * u1 * u2)) && !(r >= Math.log(z)));
        return gamma + beta * X;
    }

    private void init() {
        this.aa = this.alpha > 1.0 ? Math.sqrt(this.alpha + this.alpha - 1.0) : this.alpha;
        this.bb = this.alpha - 1.386294361;
        this.cc = this.alpha + this.aa;
    }
}

