/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import java.util.ArrayList;
import java.util.List;

public class Report {
    protected static int labelWidth = 24;
    protected static int indentation = 3;
    protected static int floatPrecision = 4;
    protected static int valueWidth = 0;
    protected String label;
    protected String value;
    protected List<Report> subReports;
    public static final String NEWLINE = System.getProperty("line.separator");

    public static void setLabelWidth(int labelWidth) {
        Report.labelWidth = labelWidth;
    }

    public static void setIndentation(int indentation) {
        Report.indentation = indentation;
    }

    public static void setFloatPrecision(int floatPrecision) {
        Report.floatPrecision = floatPrecision;
    }

    public static void setValueWidth(int valueWidth) {
        Report.valueWidth = valueWidth;
    }

    public Report(String label, String value) {
        this.label = label;
        this.value = value == null ? null : String.format("%" + (valueWidth == 0 ? "" : Integer.valueOf(valueWidth)) + "s", value);
        this.subReports = new ArrayList<Report>();
    }

    public Report(String label, int value) {
        this(label, String.format("%d", value));
    }

    public Report(String label, double value) {
        this(label, String.format("%." + floatPrecision + "g", value));
    }

    public Report(String label, int[] value) {
        this(label, Report.formatVector(value));
    }

    public Report(String label, double[] value) {
        this(label, Report.formatVector(value));
    }

    public Report(String label, boolean value) {
        this(label, value ? "yes" : "no");
    }

    public Report(String label) {
        this.label = label;
        this.value = null;
        this.subReports = new ArrayList<Report>();
    }

    public Report() {
        this(null);
    }

    public void add(Report subReport) {
        this.subReports.add(subReport);
    }

    public void add(String label, String value) {
        this.add(new Report(label, value));
    }

    public void add(String label, int value) {
        this.add(new Report(label, value));
    }

    public void add(String label, double value) {
        this.add(new Report(label, value));
    }

    public void add(String label, boolean value) {
        this.add(new Report(label, value));
    }

    public void add(String label, int[] value) {
        this.add(new Report(label, value));
    }

    public void add(String label, double[] value) {
        this.add(new Report(label, value));
    }

    public void add(String label) {
        this.add(new Report(label));
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int baseIndentation) {
        String s = "";
        if (this.label != null) {
            if (baseIndentation > 0) {
                s = s + String.format("%" + baseIndentation + "s", "");
            }
            s = this.value != null ? s + String.format("%" + (labelWidth == 0 ? "" : Integer.valueOf(labelWidth)) + "s %s", this.label + ":", this.value) : s + "==> " + this.label;
            s = s + NEWLINE;
        }
        if (!this.subReports.isEmpty()) {
            for (Report report : this.subReports) {
                s = s + report.toString(baseIndentation + indentation);
            }
        }
        return s;
    }

    protected static String formatVector(int[] value) {
        String s = "";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                s = s + " ";
            }
            s = s + String.format("%d", value[i]);
        }
        return s;
    }

    protected static String formatVector(double[] value) {
        String s = "";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                s = s + " ";
            }
            s = s + String.format("%." + floatPrecision + "g", value[i]);
        }
        return s;
    }
}

