/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import java.util.ArrayList;
import java.util.List;
import umontreal.ssj.mcqmctools.anova.CoordinateSet;

public class CoordinateSetLong
extends CoordinateSet {
    protected long mask;

    public CoordinateSetLong(long mask) {
        this.mask = mask;
    }

    public long getMask() {
        return this.mask;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CoordinateSetLong) {
            return this.mask == ((CoordinateSetLong)o).mask;
        }
        return super.equals(o);
    }

    @Override
    public List<Integer> asList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int coord = 0;
        for (long x = this.mask; x != 0L; x >>= 1) {
            if ((x & 1L) == 1L) {
                list.add(coord);
            }
            ++coord;
        }
        return list;
    }

    @Override
    public boolean contains(int coord) {
        return (this.mask >> coord & 1L) == 1L;
    }

    @Override
    public boolean containsAll(CoordinateSet cs) {
        if (cs instanceof CoordinateSetLong) {
            return (this.mask | ((CoordinateSetLong)cs).mask) == this.mask;
        }
        return super.containsAll(cs);
    }

    @Override
    public int cardinality() {
        int count = 0;
        for (long x = this.mask; x != 0L; x &= x - 1L) {
            ++count;
        }
        return count;
    }

    @Override
    public int maxCoordinate() {
        int c = 0;
        while (this.mask >> c != 0L) {
            ++c;
        }
        return c - 1;
    }

    @Override
    public List<CoordinateSet> subsets(boolean includeEmptySet, int maxOrder) {
        int order;
        maxOrder = Math.min(maxOrder, this.maxCoordinate() + 1);
        long maskMax = 1L << this.maxCoordinate() + 1;
        ArrayList<CoordinateSet> list = new ArrayList<CoordinateSet>();
        int n = order = includeEmptySet ? 0 : 1;
        while (order <= maxOrder) {
            long mask = (1L << order) - 1L;
            while (mask < maskMax) {
                long u;
                long v;
                CoordinateSetLong cs = new CoordinateSetLong(mask);
                if (this.containsAll(cs)) {
                    list.add(cs);
                }
                if ((v = mask + (u = mask & -mask)) == 0L) break;
                mask = v + ((v ^ mask) / u >> 2);
            }
            ++order;
        }
        return list;
    }

    public static CoordinateSet allCoordinates(int dimension) {
        return new CoordinateSetLong((1L << dimension) - 1L);
    }
}

