/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import umontreal.ssj.mcqmctools.anova.AnovaObserver;
import umontreal.ssj.mcqmctools.anova.CoordinateSet;
import umontreal.ssj.mcqmctools.anova.PartialVariance;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.list.ListOfTallies;
import umontreal.ssj.util.PrintfFormat;

public class AnovaVarianceCollector
extends ListOfTallies<PartialVariance> {
    protected List<AnovaObserver> observers;
    protected Tally meanCorrection;
    protected Tally totalVar = new Tally("Total variance");
    protected boolean sorted = false;

    public AnovaVarianceCollector(Iterable<CoordinateSet> coordSets) {
        this.meanCorrection = new Tally("Correction to the mean");
        for (CoordinateSet cs : coordSets) {
            this.add(new PartialVariance(cs, this.totalVar));
        }
        this.observers = new ArrayList<AnovaObserver>();
    }

    public void addObserver(AnovaObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void init() {
        super.init();
        this.meanCorrection.init();
        this.totalVar.init();
    }

    @Override
    public void add(double[] vars) {
        if (this.sorted) {
            throw new IllegalStateException("AnovaVarianceCollector cannot collect data once sorted");
        }
        for (int i = 0; i < this.size(); ++i) {
            ((PartialVariance)this.get(i)).add(vars[i]);
        }
        this.meanCorrection.add(vars[this.size()]);
        this.totalVar.add(vars[this.size() + 1]);
        for (AnovaObserver obs : this.observers) {
            obs.anovaUpdated(this);
        }
    }

    public void sort() {
        Collections.sort(this, Collections.reverseOrder());
        this.sorted = true;
    }

    public Tally getMeanCorrection() {
        return this.meanCorrection;
    }

    public Tally getTotalVariance() {
        return this.totalVar;
    }

    public double getVarianceForOrder(int order) {
        double sum = 0.0;
        for (PartialVariance c : this) {
            if (c.getCoordinates().cardinality() != order) continue;
            sum += c.average();
        }
        return sum;
    }

    public double getVarianceFractionForOrder(int order) {
        double sum = 0.0;
        for (PartialVariance c : this) {
            if (c.getCoordinates().cardinality() != order) continue;
            sum += c.sensitivityIndex();
        }
        return sum;
    }

    public double getTotalVarianceForCoordinate(CoordinateSet coords) {
        for (PartialVariance c : this) {
            if (!c.getCoordinates().equals(coords)) continue;
            return c.average();
        }
        return -1.0;
    }

    public double getTotalVarianceForCoordinate(int coord) {
        double sum = 0.0;
        for (PartialVariance c : this) {
            if (!c.getCoordinates().contains(coord)) continue;
            sum += c.average();
        }
        return sum;
    }

    public int getMaxOrder() {
        int x = 0;
        for (PartialVariance c : this) {
            x = Math.max(x, c.getCoordinates().cardinality());
        }
        return x;
    }

    public String toString() {
        String s = "ANOVA Collector";
        s = s + String.format(" [maxOrder=%d]", this.getMaxOrder());
        return s;
    }

    @Override
    public String report() {
        double dvar;
        String report = "";
        report = report + String.format("%30s: %9.4g", "Correction to mean", this.getMeanCorrection().average());
        if (this.getMeanCorrection().numberObs() > 1) {
            dvar = Math.sqrt(this.getMeanCorrection().variance() / (double)this.getMeanCorrection().numberObs());
            report = report + String.format(" \u00b1 %.2g", dvar);
        }
        report = report + PrintfFormat.NEWLINE;
        report = report + String.format("%30s: %9.4g", "Total variance", this.getTotalVariance().average());
        if (this.getTotalVariance().numberObs() > 1) {
            dvar = Math.sqrt(this.getTotalVariance().variance() / (double)this.getTotalVariance().numberObs());
            report = report + String.format(" \u00b1 %.2g", dvar);
        }
        report = report + PrintfFormat.NEWLINE;
        report = report + PrintfFormat.NEWLINE;
        for (PartialVariance c : this) {
            report = report + c + PrintfFormat.NEWLINE;
        }
        for (int i = 1; i <= this.getMaxOrder(); ++i) {
            report = report + PrintfFormat.NEWLINE + String.format("%30s: %9.4g  (%.4g %%)", String.format("order %d", i), this.getVarianceForOrder(i), this.getVarianceFractionForOrder(i) * 100.0);
        }
        return report;
    }
}

