/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.mcqmctools.MonteCarloModel;
import umontreal.ssj.mcqmctools.anova.AnovaObserver;
import umontreal.ssj.mcqmctools.anova.AnovaVarianceCollector;
import umontreal.ssj.mcqmctools.anova.AnovaVarianceEstimator;
import umontreal.ssj.mcqmctools.anova.CoordinateSetLong;
import umontreal.ssj.mcqmctools.anova.Integrator;
import umontreal.ssj.mcqmctools.anova.MonteCarloModelDoubleRQMC;
import umontreal.ssj.mcqmctools.anova.RandomIntegrator;
import umontreal.ssj.util.PrintfFormat;

public class Anova {
    protected int maxOrder = Integer.MAX_VALUE;
    protected int maxCoordinate = Integer.MAX_VALUE;
    protected RandomIntegrator innerIntegrator;
    protected Integrator outerIntegrator;

    public Anova(Integrator outerIntegrator, RandomIntegrator innerIntegrator) {
        this.outerIntegrator = outerIntegrator;
        this.innerIntegrator = innerIntegrator;
    }

    public Anova() {
        this(null, null);
    }

    public void setOuterIntegrator(Integrator integrator) {
        this.outerIntegrator = integrator;
    }

    public void setInnerIntegrator(RandomIntegrator integrator) {
        this.innerIntegrator = integrator;
    }

    public void setMaxCoordinate(int maxCoordinate) {
        this.maxCoordinate = maxCoordinate;
    }

    public void setMaxOrder(int maxOrder) {
        this.maxOrder = maxOrder;
    }

    public AnovaVarianceCollector estimate(MonteCarloModelDoubleRQMC model, double approxMean) {
        return this.estimate(model, approxMean, null);
    }

    public AnovaVarianceCollector estimate(MonteCarloModelDoubleRQMC model, double approxMean, AnovaObserver observer) {
        int dimension = Math.min(this.maxCoordinate + 1, model.getDimension());
        AnovaVarianceEstimator varEstimator = new AnovaVarianceEstimator();
        varEstimator.setModel(model, approxMean);
        varEstimator.setCoordinates(CoordinateSetLong.allCoordinates(dimension), this.maxOrder);
        varEstimator.setIntegrator(this.innerIntegrator);
        AnovaVarianceCollector varCollector = new AnovaVarianceCollector(varEstimator.getCoordinateSets());
        if (observer != null) {
            varCollector.addObserver(observer);
        }
        this.outerIntegrator.integrate((MonteCarloModel<double[]>)varEstimator, varCollector);
        varCollector.sort();
        return varCollector;
    }

    public String toString() {
        String s = "ANOVA";
        if (this.maxCoordinate < Integer.MAX_VALUE) {
            s = s + " [maxCoordinate=" + this.maxCoordinate + "]";
        }
        if (this.maxOrder < Integer.MAX_VALUE) {
            s = s + " [maxOrder=" + this.maxOrder + "]";
        }
        if (this.outerIntegrator != null) {
            s = s + PrintfFormat.NEWLINE;
            s = s + "  Outer Integrator:";
            s = s + PrintfFormat.NEWLINE;
            s = s + "    " + this.outerIntegrator;
        }
        if (this.innerIntegrator != null) {
            s = s + PrintfFormat.NEWLINE;
            s = s + "  Inner Integrator:";
            s = s + PrintfFormat.NEWLINE;
            s = s + "    " + this.innerIntegrator;
        }
        return s;
    }
}

