/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.markovchainrqmc;

import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.MRG32k3a;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.util.Chrono;
import umontreal.ssj.util.PrintfFormat;

public abstract class MarkovChain
implements Cloneable {
    Chrono timer = Chrono.createForSingleThread();
    int numSteps;
    protected boolean stopped = false;

    public abstract void initialState();

    public abstract void nextStep(RandomStream var1);

    public abstract double getPerformance();

    public Object clone() throws CloneNotSupportedException {
        MarkovChain o = null;
        try {
            o = (MarkovChain)super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("This MarkovChain cannot be cloned");
        }
        return o;
    }

    public boolean hasStopped() {
        return this.stopped;
    }

    public void simulSteps(int numSteps, RandomStream stream) {
        this.initialState();
        this.numSteps = numSteps;
        for (int step = 0; step < numSteps && !this.hasStopped(); ++step) {
            this.nextStep(stream);
        }
    }

    public void simulSteps(RandomStream stream) {
        this.simulSteps(Integer.MAX_VALUE, stream);
    }

    public void simulRuns(int n, int numSteps, RandomStream stream, Tally statRuns) {
        statRuns.init();
        for (int i = 0; i < n; ++i) {
            this.simulSteps(numSteps, stream);
            statRuns.add(this.getPerformance());
        }
    }

    public void simulRunsWithSubstreams(int n, int numSteps, RandomStream stream, Tally statRuns) {
        statRuns.init();
        stream.resetStartStream();
        for (int i = 0; i < n; ++i) {
            this.simulSteps(numSteps, stream);
            statRuns.add(this.getPerformance());
            stream.resetNextSubstream();
        }
    }

    public double simulMC(int n, int numSteps) {
        Tally statRuns = new Tally();
        this.simulRunsWithSubstreams(n, numSteps, new MRG32k3a(), statRuns);
        return statRuns.average();
    }

    public double simulMC(int n) {
        return this.simulMC(n, Integer.MAX_VALUE);
    }

    public void simulRepMC(int n, int numSteps, int m, Tally t) {
        for (int rep = 0; rep < m; ++rep) {
            t.add(this.simulMC(n, numSteps));
        }
    }

    public void simulRepMC(int n, int m, Tally t) {
        this.simulRepMC(n, Integer.MAX_VALUE, m, t);
    }

    public void simulRQMC(PointSet p, int m, int numSteps, PointSetRandomization rand, Tally statReps) {
        statReps.init();
        Tally statRuns = new Tally();
        int n = p.getNumPoints();
        PointSetIterator stream = p.iterator();
        for (int rep = 0; rep < m; ++rep) {
            p.randomize(rand);
            this.simulRunsWithSubstreams(n, numSteps, stream, statRuns);
            statReps.add(statRuns.average());
        }
    }

    public String simulRunsFormat(int n, int numSteps, RandomStream stream, Tally statRuns) {
        this.timer.init();
        this.simulRuns(n, numSteps, stream, statRuns);
        StringBuffer sb = new StringBuffer("----------------------------------------------" + PrintfFormat.NEWLINE);
        sb.append("MC simulations:" + PrintfFormat.NEWLINE);
        sb.append(" Number of runs n          = " + n + PrintfFormat.NEWLINE);
        sb.append(this.formatResults(statRuns));
        sb.append(" CPU Time = " + this.timer.format() + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public String simulRunsWithSubstreamsFormat(int n, int numSteps, RandomStream stream, Tally statRuns) {
        this.timer.init();
        this.simulRunsWithSubstreams(n, numSteps, stream, statRuns);
        StringBuffer sb = new StringBuffer("----------------------------------------------" + PrintfFormat.NEWLINE);
        sb.append("MC simulations with substreams:" + PrintfFormat.NEWLINE);
        sb.append(" Number of runs n          = " + n + PrintfFormat.NEWLINE);
        sb.append(this.formatResults(statRuns));
        sb.append(" CPU Time = " + this.timer.format() + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public String simulRQMCFormat(PointSet p, int m, int numSteps, PointSetRandomization rand, Tally statReps) {
        this.timer.init();
        this.simulRQMC(p, m, numSteps, rand, statReps);
        int n = p.getNumPoints();
        StringBuffer sb = new StringBuffer("----------------------------------------------" + PrintfFormat.NEWLINE);
        sb.append("RQMC simulations:" + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        sb.append(p.toString());
        sb.append(PrintfFormat.NEWLINE + " Number of indep. randomization, m = " + m + PrintfFormat.NEWLINE);
        sb.append(" Number of points n        = " + n + PrintfFormat.NEWLINE);
        sb.append(this.formatResultsRQMC(statReps, n));
        sb.append(" CPU Time = " + this.timer.format() + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public String testImprovementRQMCFormat(PointSet p, int m, int numSteps, PointSetRandomization rand, double varMC, Tally statReps) {
        StringBuffer sb = new StringBuffer(this.simulRQMCFormat(p, m, numSteps, rand, statReps));
        double var = (double)p.getNumPoints() * statReps.variance();
        sb.append(" Variance ratio: " + PrintfFormat.format(15, 10, 4, varMC / var) + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public String formatResults(Tally stat) {
        StringBuffer sb = new StringBuffer(" Average value             = ");
        sb.append(PrintfFormat.format(12, 9, 5, stat.average()) + PrintfFormat.NEWLINE);
        sb.append(" Variance                  = ");
        sb.append(PrintfFormat.format(12, 9, 5, stat.variance()) + PrintfFormat.NEWLINE);
        sb.append(stat.formatCIStudent(0.9, 7));
        return sb.toString();
    }

    public String formatResultsRQMC(Tally stat, int numPoints) {
        StringBuffer sb = new StringBuffer(" Average value             = ");
        sb.append(PrintfFormat.format(12, 9, 5, stat.average()) + PrintfFormat.NEWLINE);
        sb.append(" Variance * numPoints      = ");
        sb.append(PrintfFormat.format(12, 9, 5, (double)numPoints * stat.variance()) + PrintfFormat.NEWLINE);
        sb.append(stat.formatCIStudent(0.9, 7));
        return sb.toString();
    }
}

