/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.ContainerPointSet;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.util.PrintfFormat;

public class AntitheticPointSet
extends ContainerPointSet {
    public AntitheticPointSet(PointSet p) {
        this.init(p);
    }

    @Override
    public double getCoordinate(int i, int j) {
        return 1.0 - this.P.getCoordinate(i, j);
    }

    @Override
    public PointSetIterator iterator() {
        return new AntitheticPointSetIterator();
    }

    @Override
    public String toString() {
        return "Antithetic point set of: {" + PrintfFormat.NEWLINE + this.P.toString() + PrintfFormat.NEWLINE + "}";
    }

    protected class AntitheticPointSetIterator
    extends ContainerPointSet.ContainerPointSetIterator {
        protected AntitheticPointSetIterator() {
        }

        @Override
        public double nextCoordinate() {
            return 1.0 - this.innerIterator.nextCoordinate();
        }

        @Override
        public double nextDouble() {
            return 1.0 - this.innerIterator.nextCoordinate();
        }

        @Override
        public void nextCoordinates(double[] p, int d) {
            this.innerIterator.nextCoordinates(p, d);
            for (int j = 0; j < d; ++j) {
                p[j] = 1.0 - p[j];
            }
        }

        @Override
        public int nextPoint(double[] p, int d) {
            this.innerIterator.nextPoint(p, d);
            for (int j = 0; j < d; ++j) {
                p[j] = 1.0 - p[j];
            }
            return this.getCurPointIndex();
        }
    }
}

