/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.gof;

import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.probdist.EmpiricalDist;

public class KernelDensity {
    private static double estimate(EmpiricalDist dist, ContinuousDistribution kern, double h, double y) {
        double a = kern.getXinf();
        double b = kern.getXsup();
        double sum = 0.0;
        int n = dist.getN();
        for (int i = 0; i < n; ++i) {
            double z = (y - dist.getObs(i)) / h;
            if (!(z >= a) || !(z <= b)) continue;
            sum += kern.density(z);
        }
        return sum /= h * (double)n;
    }

    public static double[] computeDensity(EmpiricalDist dist, ContinuousDistribution kern, double h, double[] Y) {
        int m = Y.length;
        double[] u = new double[m];
        for (int j = 0; j < m; ++j) {
            u[j] = KernelDensity.estimate(dist, kern, h, Y[j]);
        }
        return u;
    }

    public void evalDensity(double[] data, ContinuousDistribution kern, double h, double[] evalPoints, double[] density, double epsilon0) {
        int m = evalPoints.length;
        int n = data.length;
        double invhn = 1.0 / (h * (double)n);
        double invh = 1.0 / h;
        double sum = 0.0;
        int imin = 0;
        for (int j = 0; j < m; ++j) {
            double y = evalPoints[j];
            double term = kern.density((y - data[imin]) * invh);
            while (term < epsilon0 & imin < n - 1 && data[imin] < y) {
                term = kern.density((y - data[++imin]) * invh);
            }
            sum = term;
            for (int i = imin + 1; i < n && (term > epsilon0 || data[i] < y); ++i) {
                term = kern.density((y - data[i]) * invh);
                sum += term;
            }
            density[j] = sum * invhn;
        }
    }
}

