/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;

public class DiscShiftBaker1
extends Discrepancy {
    protected static double[] setC(double gam) {
        double[] C = new double[3];
        double v = gam * gam;
        C[0] = v * 4.0 / 3.0;
        v *= v;
        C[1] = v / 9.0;
        C[2] = v * 16.0 / 45.0;
        return C;
    }

    protected static void setC(double[] C1, double[] C2, double[] C3, double[] gam, int s) {
        for (int i = 0; i < s; ++i) {
            double v = gam[i] * gam[i];
            C1[i] = v * 4.0 / 3.0;
            v *= v;
            C2[i] = v / 9.0;
            C3[i] = v * 16.0 / 45.0;
        }
    }

    public DiscShiftBaker1(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscShiftBaker1(double[][] points, int n, int s, double[] gamma) {
        super(points, n, s, gamma);
    }

    public DiscShiftBaker1(int n, int s, double[] gamma) {
        super(n, s, gamma);
    }

    public DiscShiftBaker1(PointSet set) {
        super(set);
    }

    public DiscShiftBaker1() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        DiscShiftBaker1.setONES(s);
        return this.compute(points, n, s, ONES);
    }

    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        double temp;
        double[] C1 = new double[s];
        double[] C2 = new double[s];
        double[] C3 = new double[s];
        DiscShiftBaker1.setC(C1, C2, C3, gamma, s);
        double pol1 = -0.03333333333333333;
        double pol2 = 0.029166666666666667;
        double pol3 = 0.023809523809523808;
        double pol4 = -0.023065476190476192;
        double prod = 1.0;
        for (int r = 0; r < s; ++r) {
            temp = C1[r] * (pol1 - pol2) + C2[r] * (7.0 * pol1 - 2.0 * pol2) + C3[r] * (pol3 - pol4);
            prod *= 1.0 - temp;
        }
        double disc = prod / (double)n;
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                prod = 1.0;
                for (int r = 0; r < s; ++r) {
                    double u = points[i][r] - points[j][r];
                    if (u < 0.0) {
                        u += 1.0;
                    }
                    pol1 = ((u - 2.0) * u + 1.0) * u * u - 0.03333333333333333;
                    double v = u - 0.5;
                    if (v < 0.0) {
                        v += 1.0;
                    }
                    pol2 = ((v - 2.0) * v + 1.0) * v * v - 0.03333333333333333;
                    pol3 = (((u - 3.0) * u + 2.5) * u * u - 0.5) * u * u + 0.023809523809523808;
                    pol4 = (((v - 3.0) * v + 2.5) * v * v - 0.5) * v * v + 0.023809523809523808;
                    temp = C1[r] * (pol1 - pol2) + C2[r] * (7.0 * pol1 - 2.0 * pol2) + C3[r] * (pol3 - pol4);
                    prod *= 1.0 - temp;
                }
                sum += prod;
            }
        }
        if ((disc += 2.0 * sum / (double)((long)n * (long)n) - 1.0) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        return this.compute(T, n, 1.0);
    }

    @Override
    public double compute(double[] T, int n, double gamma) {
        double[] C = DiscShiftBaker1.setC(gamma);
        double C1 = C[0];
        double C2 = C[1];
        double C3 = C[2];
        double pol1 = -0.03333333333333333;
        double pol2 = 0.029166666666666667;
        double temp = C1 * (pol1 - pol2) + C2 * (7.0 * pol1 - 2.0 * pol2) + C3 * 0.046875;
        double disc = -temp / (double)n;
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double h = T[i] - T[j];
                if (h < 0.0) {
                    h += 1.0;
                }
                pol1 = ((h - 2.0) * h + 1.0) * h * h - 0.03333333333333333;
                double v = h - 0.5;
                if (v < 0.0) {
                    v += 1.0;
                }
                pol2 = ((v - 2.0) * v + 1.0) * v * v - 0.03333333333333333;
                temp = C1 * (pol1 - pol2) + C2 * (7.0 * pol1 - 2.0 * pol2);
                pol1 = (((h - 3.0) * h + 2.5) * h * h - 0.5) * h * h + 0.023809523809523808;
                pol2 = (((v - 3.0) * v + 2.5) * v * v - 0.5) * v * v + 0.023809523809523808;
                sum -= (temp += C3 * (pol1 - pol2));
            }
        }
        if ((disc += 2.0 * sum / (double)((long)n * (long)n)) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }
}

