/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;

public class DiscL2Star
extends Discrepancy {
    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        return this.compute(points, n, s);
    }

    public DiscL2Star(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscL2Star(int n, int s) {
        super(null, n, s);
    }

    public DiscL2Star(PointSet set) {
        super(set);
    }

    public DiscL2Star() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        int j;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double prod = 1.0;
            for (int j2 = 0; j2 < s; ++j2) {
                double u = points[i][j2];
                prod *= (1.0 - u) * (1.0 + u);
            }
            sum += prod;
        }
        double disc = -Math.pow(0.5, s - 1) * sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double prod = 1.0;
            for (j = 0; j < s; ++j) {
                prod *= 1.0 - points[i][j];
            }
            sum += prod;
        }
        double sum2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (j = i + 1; j < n; ++j) {
                double prod = 1.0;
                for (int k = 0; k < s; ++k) {
                    prod *= 1.0 - Math.max(points[i][k], points[j][k]);
                }
                sum2 += prod;
            }
        }
        disc += (sum + 2.0 * sum2) / (double)((long)n * (long)n);
        if ((disc += Math.pow(0.3333333333333333, s)) < 0.0) {
            return 0.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        double W2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double v = T[i] - ((double)i + 0.5) / (double)n;
            W2 += v * v;
        }
        return Math.sqrt((W2 += 1.0 / (12.0 * (double)n)) / (double)n);
    }
}

