/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;

public class DiscL2Hickernell
extends Discrepancy {
    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        return this.compute(points, n, s);
    }

    public DiscL2Hickernell(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscL2Hickernell(int n, int s) {
        super(null, n, s);
    }

    public DiscL2Hickernell(PointSet set) {
        super(set);
    }

    public DiscL2Hickernell() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        int j;
        int N = n;
        double RAC3 = 1.7320508075688772;
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double prod = 1.0;
            for (int j2 = 0; j2 < s; ++j2) {
                double u = points[i][j2];
                prod *= (1.7320508075688772 - u) * (1.7320508075688772 + u);
            }
            sum += prod;
        }
        double disc = -Math.pow(0.5, s - 1) * sum / (double)N;
        sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double prod = 1.0;
            for (j = 0; j < s; ++j) {
                prod *= 2.0 - points[i][j];
            }
            sum += prod;
        }
        double sum2 = 0.0;
        for (int i = 0; i < N - 1; ++i) {
            for (j = i + 1; j < N; ++j) {
                double prod = 1.0;
                for (int k = 0; k < s; ++k) {
                    prod *= 2.0 - Math.max(points[i][k], points[j][k]);
                }
                sum2 += prod;
            }
        }
        disc += (sum + 2.0 * sum2) / (double)((long)N * (long)N);
        if ((disc += Math.pow(1.3333333333333333, s)) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += T[i] * T[i];
        }
        double disc = sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += T[i];
        }
        double sum2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                sum2 += Math.max(T[i], T[j]);
            }
        }
        disc -= (sum + 2.0 * sum2) / (double)((long)n * (long)n);
        if ((disc += 0.3333333333333333) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }
}

