/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.util;

public class BandwidthSimulator {
    private static final float DAMPING_FACTOR = 0.5f;
    private long startTime;
    private int sleepTime;
    private float damping;
    private final int targetBps;
    private final int bufferIncrement;

    public BandwidthSimulator(int targetBPS) {
        this.targetBps = targetBPS;
        this.bufferIncrement = Math.max(100, this.targetBps / 500);
    }

    public int maximumBytes(int position) {
        if (this.targetBps == 0) {
            return Integer.MAX_VALUE;
        }
        long now = System.currentTimeMillis();
        if (position == 0) {
            this.startTime = now;
            this.sleepTime = 0;
            this.damping = 2.0f;
        } else {
            long expectedTime = (long)position * 8L * 1000L / (long)this.targetBps;
            long actualTime = now - this.startTime;
            this.sleepTime = (int)((float)this.sleepTime + (float)(expectedTime - actualTime) * this.damping);
            if (this.sleepTime < 0) {
                this.sleepTime = 0;
            }
            this.damping = 0.5f;
        }
        try {
            Thread.sleep(this.sleepTime, 0);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        return this.bufferIncrement;
    }
}

