/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.browsermob.proxy.util.Log;

public class RequestCookiesInterceptor
implements HttpRequestInterceptor {
    private static final Log LOG = new Log();

    public void process(HttpRequest request, HttpContext context) {
        URI requestURI;
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            LOG.fine("Cookie store not specified in HTTP context", new Object[0]);
            return;
        }
        CookieSpecRegistry registry = (CookieSpecRegistry)context.getAttribute("http.cookiespec-registry");
        if (registry == null) {
            LOG.fine("CookieSpec registry not specified in HTTP context", new Object[0]);
            return;
        }
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        if (targetHost == null) {
            LOG.fine("Target host not set in the context", new Object[0]);
            return;
        }
        ManagedClientConnection conn = (ManagedClientConnection)context.getAttribute("http.connection");
        if (conn == null) {
            LOG.fine("HTTP connection not set in the context", new Object[0]);
            return;
        }
        String policy = HttpClientParams.getCookiePolicy((HttpParams)request.getParams());
        LOG.fine("CookieSpec selected: " + policy, new Object[0]);
        if (request instanceof HttpUriRequest) {
            requestURI = ((HttpUriRequest)request).getURI();
        } else {
            try {
                requestURI = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException ex) {
                LOG.fine("Invalid request URI: " + request.getRequestLine().getUri(), ex);
                return;
            }
        }
        String hostName = targetHost.getHostName();
        int port = targetHost.getPort();
        if (port < 0) {
            SchemeRegistry sr = (SchemeRegistry)context.getAttribute("http.scheme-registry");
            if (sr != null) {
                Scheme scheme = sr.get(targetHost.getSchemeName());
                port = scheme.resolvePort(port);
            } else {
                port = conn.getRemotePort();
            }
        }
        CookieOrigin cookieOrigin = new CookieOrigin(hostName, port, requestURI.getPath(), conn.isSecure());
        CookieSpec cookieSpec = registry.getCookieSpec(policy, request.getParams());
        ArrayList cookies = new ArrayList(cookieStore.getCookies());
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired(now)) {
                if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                LOG.fine("Cookie " + cookie + " match " + cookieOrigin, new Object[0]);
                matchedCookies.add(cookie);
                continue;
            }
            LOG.fine("Cookie " + cookie + " expired", new Object[0]);
        }
        context.setAttribute("browsermob.http.request.cookies", matchedCookies);
    }
}

