/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.browsermob.core.har.Har;
import org.browsermob.core.har.HarLog;
import org.browsermob.core.har.HarNameVersion;
import org.browsermob.core.har.HarPage;
import org.browsermob.proxy.BrowserMobProxyHandler;
import org.browsermob.proxy.http.BrowserMobHttpClient;
import org.browsermob.proxy.jetty.http.HttpContext;
import org.browsermob.proxy.jetty.http.SocketListener;
import org.browsermob.proxy.jetty.jetty.Server;
import org.browsermob.proxy.jetty.util.InetAddrPort;
import org.openqa.selenium.Proxy;

public class ProxyServer {
    private static final HarNameVersion CREATOR = new HarNameVersion("BrowserMob Proxy", "2.0");
    private Server server;
    private int port = -1;
    private BrowserMobHttpClient client;
    private HarPage currentPage;
    private BrowserMobProxyHandler handler;
    private int pageCount = 1;

    public ProxyServer() {
    }

    public ProxyServer(int port) {
        this.port = port;
    }

    public void start() throws Exception {
        if (this.port == -1) {
            throw new IllegalStateException("Must set port before starting");
        }
        this.server = new Server();
        SocketListener listener = new SocketListener(new InetAddrPort(this.getPort()));
        this.server.addListener(listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        this.server.addContext(context);
        this.handler = new BrowserMobProxyHandler();
        this.handler.setJettyServer(this.server);
        this.handler.setShutdownLock(new Object());
        this.client = new BrowserMobHttpClient();
        this.client.prepareForBrowser();
        this.handler.setHttpClient(this.client);
        this.client.setDownstreamKbps(4096000L);
        context.addHandler(this.handler);
        this.server.start();
        this.setPort(listener.getPort());
    }

    public Proxy seleniumProxy() throws UnknownHostException {
        Proxy proxy = new Proxy();
        proxy.setProxyType(Proxy.ProxyType.MANUAL);
        String proxyStr = String.format("%s:%d", InetAddress.getLocalHost().getCanonicalHostName(), this.getPort());
        proxy.setHttpProxy(proxyStr);
        proxy.setSslProxy(proxyStr);
        return proxy;
    }

    public void cleanup() {
        this.handler.cleanup();
    }

    public void stop() throws Exception {
        this.cleanup();
        this.client.shutdown();
        this.server.stop();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Har getHar() {
        return this.client.getHar();
    }

    public Har newHar(String initialPageRef) {
        this.pageCount = 1;
        Har oldHar = this.getHar();
        Har har = new Har(new HarLog(CREATOR));
        this.client.setHar(har);
        this.newPage(initialPageRef);
        return oldHar;
    }

    public void newPage(String pageRef) {
        if (pageRef == null) {
            pageRef = "Page " + this.pageCount;
        }
        this.client.setHarPageRef(pageRef);
        this.currentPage = new HarPage(pageRef);
        this.client.getHar().getLog().addPage(this.currentPage);
        ++this.pageCount;
    }

    public void endPage() {
        if (this.currentPage == null) {
            return;
        }
        this.currentPage.getPageTimings().setOnLoad(new Date().getTime() - this.currentPage.getStartedDateTime().getTime());
        this.client.setHarPageRef(null);
        this.currentPage = null;
    }

    public void setRetryCount(int count) {
        this.client.setRetryCount(count);
    }

    public void remapHost(String source, String target) {
        this.client.remapHost(source, target);
    }

    public void addRequestInterceptor(HttpRequestInterceptor i) {
        this.client.addRequestInterceptor(i);
    }

    public void addResponseInterceptor(HttpResponseInterceptor i) {
        this.client.addResponseInterceptor(i);
    }

    public void setDownstreamKbps(long downstreamKbps) {
        this.client.setDownstreamKbps(downstreamKbps);
    }

    public void setUpstreamKbps(long upstreamKbps) {
        this.client.setUpstreamKbps(upstreamKbps);
    }

    public void setLatency(long latency) {
        this.client.setLatency(latency);
    }

    public void setRequestTimeout(int requestTimeout) {
        this.client.setRequestTimeout(requestTimeout);
    }

    public void setSocketOperationTimeout(int readTimeout) {
        this.client.setSocketOperationTimeout(readTimeout);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.client.setConnectionTimeout(connectionTimeout);
    }

    public void autoBasicAuthorization(String domain, String username, String password) {
        this.client.autoBasicAuthorization(domain, username, password);
    }

    public void rewriteUrl(String match, String replace) {
        this.client.rewriteUrl(match, replace);
    }

    public void blacklistRequests(String pattern, int responseCode) {
        this.client.blacklistRequests(pattern, responseCode);
    }

    public void whitelistRequests(String[] patterns, int responseCode) {
        this.client.whitelistRequests(patterns, responseCode);
    }

    public void addHeader(String name, String value) {
        this.client.addHeader(name, value);
    }

    public void setCaptureHeaders(boolean captureHeaders) {
        this.client.setCaptureHeaders(captureHeaders);
    }

    public void setCaptureContent(boolean captureContent) {
        this.client.setCaptureContent(captureContent);
    }

    public void clearDNSCache() {
        this.client.clearDNSCache();
    }

    public void setDNSCacheTimeout(int timeout) {
        this.client.setDNSCacheTimeout(timeout);
    }

    public void waitForNetworkTrafficToStop(long quietPeriodInMs, long timeoutInMs) {
    }

    public void setOptions(Map<String, String> options) {
        if (options.containsKey("httpProxy")) {
            this.client.setHttpProxy(options.get("httpProxy"));
        }
    }
}

