/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip;

import java.io.IOException;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip.ToolTip;

final class FontToolTip
implements ToolTip {
    private String markup;

    FontToolTip(PDResources resources, String rowText) {
        this.initUI(this.extractFontReference(rowText), resources);
    }

    private void initUI(String fontReferenceName, PDResources resources) {
        PDFont font = null;
        for (COSName name : resources.getFontNames()) {
            if (!name.getName().equals(fontReferenceName)) continue;
            try {
                font = resources.getFont(name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (font != null) {
            this.markup = "<html>" + font.getName() + "</html>";
        }
    }

    private String extractFontReference(String rowText) {
        return rowText.trim().split(" ")[0].substring(1);
    }

    @Override
    public String getToolTipText() {
        return this.markup;
    }
}

