/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.flagbitspane;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.font.PDPanose;
import org.apache.pdfbox.pdmodel.font.PDPanoseClassification;
import org.apache.pdfbox.tools.pdfdebugger.flagbitspane.Flag;

public class PanoseFlag
extends Flag {
    private final byte[] bytes;
    private final COSString byteValue;

    public PanoseFlag(COSDictionary dictionary) {
        this.byteValue = (COSString)dictionary.getDictionaryObject(COSName.PANOSE);
        this.bytes = this.getPanoseBytes(dictionary);
    }

    @Override
    String getFlagType() {
        return "Panose classification";
    }

    @Override
    String getFlagValue() {
        return "Panose byte :" + this.byteValue.toHexString();
    }

    @Override
    Object[][] getFlagBits() {
        PDPanoseClassification pc = new PDPanose(this.bytes).getPanose();
        return new Object[][]{{2, "Family Kind", pc.getFamilyKind(), this.getFamilyKindValue(pc.getFamilyKind())}, {3, "Serif Style", pc.getSerifStyle(), this.getSerifStyleValue(pc.getSerifStyle())}, {4, "Weight", pc.getWeight(), this.getWeightValue(pc.getWeight())}, {5, "Proportion", pc.getProportion(), this.getProportionValue(pc.getProportion())}, {6, "Contrast", pc.getContrast(), this.getContrastValue(pc.getContrast())}, {7, "Stroke Variation", pc.getStrokeVariation(), this.getStrokeVariationValue(pc.getStrokeVariation())}, {8, "Arm Style", pc.getArmStyle(), this.getArmStyleValue(pc.getArmStyle())}, {9, "Letterform", pc.getLetterform(), this.getLetterformValue(pc.getLetterform())}, {10, "Midline", pc.getMidline(), this.getMidlineValue(pc.getMidline())}, {11, "X-height", pc.getXHeight(), this.getXHeightValue(pc.getXHeight())}};
    }

    @Override
    String[] getColumnNames() {
        return new String[]{"Byte Position", "Name", "Byte Value", "Value"};
    }

    private String getFamilyKindValue(int index) {
        return (new String[]{"Any", "No Fit", "Latin Text", "Latin Hand Written", "Latin Decorative", "Latin Symbol"})[index];
    }

    private String getSerifStyleValue(int index) {
        return (new String[]{"Any", "No Fit", "Cove", "Obtuse Cove", "Square Cove", "Obtuse Square Cove", "Square", "Thin", "Oval", "Exaggerated", "Triangle", "Normal Sans", "Obtuse Sans", "Perpendicular Sans", "Flared", "Rounded"})[index];
    }

    private String getWeightValue(int index) {
        return (new String[]{"Any", "No Fit", "Very Light", "Light", "Thin", "Book", "Medium", "Demi", "Bold", "Heavy", "Black", "Extra Black"})[index];
    }

    private String getProportionValue(int index) {
        return (new String[]{"Any", "No fit", "Old Style", "Modern", "Even Width", "Extended", "Condensed", "Very Extended", "Very Condensed", "Monospaced"})[index];
    }

    private String getContrastValue(int index) {
        return (new String[]{"Any", "No Fit", "None", "Very Low", "Low", "Medium Low", "Medium", "Medium High", "High", "Very High"})[index];
    }

    private String getStrokeVariationValue(int index) {
        return (new String[]{"Any", "No Fit", "No Variation", "Gradual/Diagonal", "Gradual/Transitional", "Gradual/Vertical", "Gradual/Horizontal", "Rapid/Vertical", "Rapid/Horizontal", "Instant/Vertical", "Instant/Horizontal"})[index];
    }

    private String getArmStyleValue(int index) {
        return (new String[]{"Any", "No Fit", "Straight Arms/Horizontal", "Straight Arms/Wedge", "Straight Arms/Vertical", "Straight Arms/Single Serif", "Straight Arms/Double Serif", "Non-Straight/Horizontal", "Non-Straight/Wedge", "Non-Straight/Vertical", "Non-Straight/Single Serif", "Non-Straight/Double Serif"})[index];
    }

    private String getLetterformValue(int index) {
        return (new String[]{"Any", "No Fit", "Normal/Contact", "Normal/Weighted", "Normal/Boxed", "Normal/Flattened", "Normal/Rounded", "Normal/Off Center", "Normal/Square", "Oblique/Contact", "Oblique/Weighted", "Oblique/Boxed", "Oblique/Flattened", "Oblique/Rounded", "Oblique/Off Center", "Oblique/Square"})[index];
    }

    private String getMidlineValue(int index) {
        return (new String[]{"Any", "No Fit", "Standard/Trimmed", "Standard/Pointed", "Standard/Serifed", "High/Trimmed", "High/Pointed", "High/Serifed", "Constant/Trimmed", "Constant/Pointed", "Constant/Serifed", "Low/Trimmed", "Low/Pointed", "Low/Serifed"})[index];
    }

    private String getXHeightValue(int index) {
        return (new String[]{"Any", "No Fit", "Constant/Small", "Constant/Standard", "Constant/Large", "Ducking/Small", "Ducking/Standard", "Ducking/Large"})[index];
    }

    public final byte[] getPanoseBytes(COSDictionary style) {
        if (style != null) {
            COSString panose = (COSString)style.getDictionaryObject(COSName.PANOSE);
            return panose.getBytes();
        }
        return null;
    }
}

