/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.gui;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;

public class PageEntry {
    private final COSDictionary dict;
    private final int pageNum;

    public PageEntry(COSDictionary page, int pageNum) {
        this.dict = page;
        this.pageNum = pageNum;
    }

    public COSDictionary getDict() {
        return this.dict;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public String toString() {
        return "Page: " + this.pageNum;
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("Root/Pages");
        COSDictionary node = this.dict;
        while (node.containsKey(COSName.PARENT)) {
            COSDictionary parent = (COSDictionary)node.getDictionaryObject(COSName.PARENT);
            COSArray kids = (COSArray)parent.getDictionaryObject(COSName.KIDS);
            int idx = kids.indexOfObject(node);
            sb.append("/Kids/[").append(idx).append("]");
            node = parent;
        }
        return sb.toString();
    }
}

