/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class ErrorDialog
extends JDialog {
    private static final List<String> FILTERS = Arrays.asList("java.awt.", "javax.swing.", "sun.reflect.", "java.util.concurrent.");
    private static final Dimension MESSAGE_SIZE = new Dimension(800, 200);
    private static final Dimension STACKTRACE_SIZE = new Dimension(800, 300);
    private static final Dimension TOTAL_SIZE = new Dimension(800, 500);
    private static final String NEWLINE = "\r\n";
    private static final String INDENT = "    ";
    private boolean showingDetails;
    private boolean isFiltering = true;
    private JComponent message;
    private JComponent main;
    private JScrollPane details;
    private JTextPane stacktrace;
    private final Throwable error;

    public ErrorDialog(Throwable t) {
        this(null, null, t);
    }

    public ErrorDialog(JComponent owner, Throwable t) {
        this(owner, null, t);
    }

    public ErrorDialog(JComponent owner, Icon icon, Throwable t) {
        this.setTitle(t.getClass().getName());
        this.setModal(true);
        if (icon != null && icon instanceof ImageIcon) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
        this.setDefaultCloseOperation(2);
        this.error = t;
        this.message = this.createErrorMessage(this.error);
        this.main = this.createContent();
        this.getContentPane().add(this.main);
        this.pack();
        ErrorDialog.position(this, owner);
    }

    static void position(Component c, Component parent) {
        Dimension d = c.getPreferredSize();
        if (parent == null) {
            Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
            c.setLocation(s.width / 2 - d.width / 2, s.height / 2 - d.height / 2);
        } else {
            Point p = parent.getLocationOnScreen();
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            c.setLocation(p.x + pw / 2 - d.width / 2, p.y + ph / 2 - d.height / 2);
        }
    }

    final JComponent createContent() {
        final JButton showDetails = new JButton("Show Details >>");
        showDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErrorDialog.this.showingDetails) {
                    ErrorDialog.this.main.remove(ErrorDialog.this.details);
                    ErrorDialog.this.main.validate();
                    ErrorDialog.this.main.setPreferredSize(MESSAGE_SIZE);
                } else {
                    if (ErrorDialog.this.details == null) {
                        ErrorDialog.this.details = ErrorDialog.this.createDetailedMessage(ErrorDialog.this.error);
                        StringBuilder buffer = new StringBuilder();
                        ErrorDialog.this.stacktrace.setText(ErrorDialog.this.generateStackTrace(ErrorDialog.this.error, buffer).toString());
                        ErrorDialog.this.stacktrace.setCaretPosition(0);
                        ErrorDialog.this.stacktrace.setBackground(ErrorDialog.this.main.getBackground());
                        ErrorDialog.this.stacktrace.setPreferredSize(STACKTRACE_SIZE);
                    }
                    ErrorDialog.this.main.add((Component)ErrorDialog.this.details, "Center");
                    ErrorDialog.this.main.validate();
                    ErrorDialog.this.main.setPreferredSize(TOTAL_SIZE);
                }
                ErrorDialog.this.showingDetails = !ErrorDialog.this.showingDetails;
                showDetails.setText(ErrorDialog.this.showingDetails ? "<< Hide Details" : "Show Details >>");
                ErrorDialog.this.pack();
            }
        });
        JPanel messagePanel = new JPanel();
        final JCheckBox filter = new JCheckBox("Filter stack traces");
        filter.setSelected(this.isFiltering);
        filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.isFiltering = filter.isSelected();
                StringBuilder buffer = new StringBuilder();
                ErrorDialog.this.stacktrace.setText(ErrorDialog.this.generateStackTrace(ErrorDialog.this.error, buffer).toString());
                ErrorDialog.this.stacktrace.setCaretPosition(0);
                ErrorDialog.this.stacktrace.repaint();
            }
        });
        this.message.setBackground(messagePanel.getBackground());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(showDetails);
        buttonPanel.add(filter);
        buttonPanel.add(Box.createHorizontalGlue());
        messagePanel.setLayout(new BorderLayout());
        messagePanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        messagePanel.add((Component)this.message, "Center");
        messagePanel.add((Component)buttonPanel, "South");
        messagePanel.setPreferredSize(MESSAGE_SIZE);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)messagePanel, "North");
        return panel;
    }

    final JComponent createErrorMessage(Throwable t) {
        String txt = t.getLocalizedMessage();
        JEditorPane msg = new JEditorPane();
        msg.setContentType("text/plain");
        msg.setEditable(false);
        msg.setText(txt);
        return msg;
    }

    JScrollPane createDetailedMessage(Throwable t) {
        this.stacktrace = new JTextPane();
        this.stacktrace.setEditable(false);
        JScrollPane pane = new JScrollPane(this.stacktrace, 20, 30);
        return pane;
    }

    StringBuilder generateStackTrace(Throwable t, StringBuilder buffer) {
        buffer.append(t.getClass().getName()).append(": ").append(t.getMessage()).append(NEWLINE);
        buffer.append((CharSequence)this.toString(t.getStackTrace()));
        Throwable cause = t.getCause();
        if (cause != null && cause != t) {
            buffer.append("Caused by: ");
            this.generateStackTrace(cause, buffer);
        }
        return buffer;
    }

    StringBuilder toString(StackTraceElement[] traces) {
        StringBuilder err = new StringBuilder();
        for (StackTraceElement e : traces) {
            if (this.isFiltering && this.isSuppressed(e.getClassName())) continue;
            String str = e.toString();
            err.append(INDENT).append(str).append(NEWLINE);
        }
        return err;
    }

    private boolean isSuppressed(String className) {
        for (String s : FILTERS) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

