/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MavenArtifact {
    public static final String DEFAULT_CLASSIFIER = "default";
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String packaging = "pom";
    protected String classifier;
    protected List<String> librariesWithResourceBundles;
    protected List<MavenArtifact> dependencies;
    protected Map<String, File> binaryArtifacts;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public List<String> getLibrariesWithResourceBundles() {
        return this.librariesWithResourceBundles;
    }

    public void setLibrariesWithResourceBundles(List<String> librariesWithResourceBundles) {
        this.librariesWithResourceBundles = librariesWithResourceBundles;
    }

    public List<MavenArtifact> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<MavenArtifact> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(MavenArtifact dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<MavenArtifact>();
        }
        this.dependencies.add(dependency);
    }

    public void addDefaultBinaryArtifact(File binaryArtifact) {
        this.addBinaryArtifact(DEFAULT_CLASSIFIER, binaryArtifact);
    }

    public void addBinaryArtifact(String classifier, File binaryArtifact) {
        if (this.binaryArtifacts == null) {
            this.binaryArtifacts = new HashMap<String, File>();
        }
        this.binaryArtifacts.put(classifier, binaryArtifact);
    }

    public boolean hasBinaryArtifact(String classifier) {
        return this.binaryArtifacts != null && this.binaryArtifacts.containsKey(classifier);
    }

    public File getPomTargetFile(File targetRootDirectory) {
        String fileName = this.groupId.replace(".", File.separator) + File.separator + this.artifactId + File.separator + this.version + File.separator + this.artifactId + "-" + this.version + (this.classifier != null ? "-" + this.classifier : "") + ".pom";
        return new File(targetRootDirectory, fileName);
    }

    public List<String> getBinaryFilesClassifiers() {
        ArrayList<String> classifiers = new ArrayList<String>();
        if (this.binaryArtifacts != null) {
            classifiers.addAll(this.binaryArtifacts.keySet());
        }
        return classifiers;
    }

    public File getBinarySourceFile(String classifier) {
        if (this.binaryArtifacts != null && this.binaryArtifacts.containsKey(classifier)) {
            return this.binaryArtifacts.get(classifier);
        }
        return null;
    }

    public File getBinaryTargetFile(File targetRootDirectory, String classifier) {
        if (this.binaryArtifacts != null && this.binaryArtifacts.containsKey(classifier)) {
            File file = this.binaryArtifacts.get(classifier);
            String type = "pom".equals(this.packaging) ? (file.getName().endsWith("zip") ? "zip" : "exe") : this.packaging;
            String fileName = this.groupId.replace(".", File.separator) + File.separator + this.artifactId + File.separator + this.version + File.separator + this.artifactId + "-" + this.version + (DEFAULT_CLASSIFIER.equals(classifier) ? "" : "-" + classifier) + "." + type;
            return new File(targetRootDirectory, fileName);
        }
        return null;
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public boolean isAtLeastOneDependencyRsl() {
        if (this.dependencies != null) {
            for (MavenArtifact dependency : this.dependencies) {
                if (!dependency.hasBinaryArtifact("rsl")) continue;
                return true;
            }
        }
        return false;
    }
}

