/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.flex.utilities.converter.api.ProxySettings;
import org.apache.flex.utilities.converter.exceptions.ConverterException;
import org.apache.flex.utilities.converter.model.MavenArtifact;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class BaseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConverter.class);
    protected final Map<String, MavenArtifact> checksums = new HashMap<String, MavenArtifact>();
    protected static final String MAVEN_CENTRAL_SHA_1_QUERY_URL = "http://search.maven.org/solrsearch/select?rows=20&wt=json&q=1:";
    protected File rootSourceDirectory;
    protected File rootTargetDirectory;
    protected Configuration freemarkerConfig;

    protected BaseConverter(File rootSourceDirectory, File rootTargetDirectory) throws ConverterException {
        if (rootSourceDirectory == null) {
            throw new ConverterException("Air SDK directory is null.");
        }
        if (rootTargetDirectory == null) {
            throw new ConverterException("Target directory is null.");
        }
        this.rootSourceDirectory = rootSourceDirectory;
        this.rootTargetDirectory = rootTargetDirectory;
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_22);
        this.freemarkerConfig.setDefaultEncoding("UTF-8");
        this.freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freemarkerConfig.setClassForTemplateLoading(this.getClass(), "/");
    }

    public void convert() throws ConverterException {
        if (this.rootSourceDirectory.isFile()) {
            this.processArchive();
        } else {
            this.processDirectory();
        }
    }

    protected abstract void processDirectory() throws ConverterException;

    protected void processArchive() throws ConverterException {
    }

    protected String calculateChecksum(File jarFile) throws ConverterException {
        InputStream is = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            is = new FileInputStream(jarFile);
            byte[] buffer = new byte[8192];
            try {
                int read;
                while ((read = is.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
                byte[] md5sum = digest.digest();
                BigInteger bigInt = new BigInteger(1, md5sum);
                String string = bigInt.toString(16);
                return string;
            }
            catch (IOException e) {
                try {
                    throw new ConverterException("Unable to process file for MD5", e);
                }
                catch (NoSuchAlgorithmException e2) {
                    throw new ConverterException("Error calculating checksum of file '" + jarFile.getPath() + "'", e2);
                }
                catch (FileNotFoundException e3) {
                    throw new ConverterException("Error calculating checksum of file '" + jarFile.getPath() + "'", e3);
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MavenArtifact lookupMetadataForChecksum(String checksum) throws ConverterException {
        String output = null;
        try {
            URLConnection connection;
            URL queryUrl = new URL(MAVEN_CENTRAL_SHA_1_QUERY_URL + checksum);
            ProxySettings proxySettings = ProxySettings.getProxySettings();
            if (proxySettings != null) {
                InetSocketAddress socketAddress = new InetSocketAddress(proxySettings.getHost(), proxySettings.getPort());
                Proxy proxy = new Proxy(Proxy.Type.valueOf(proxySettings.getProtocol().toUpperCase()), socketAddress);
                connection = queryUrl.openConnection(proxy);
            } else {
                connection = queryUrl.openConnection();
            }
            ReadableByteChannel rbc = null;
            try {
                rbc = Channels.newChannel(connection.getInputStream());
                ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                if (rbc.read(byteBuffer) > 0) {
                    output = new String(byteBuffer.array(), "UTF-8");
                }
            }
            finally {
                if (rbc != null) {
                    rbc.close();
                }
            }
        }
        catch (MalformedURLException e) {
            throw new ConverterException("Error querying maven central.", e);
        }
        catch (IOException e) {
            throw new ConverterException("Error querying maven central.", e);
        }
        if (output != null) {
            BufferedReader reader = new BufferedReader(new StringReader(output));
            StringBuilder builder = new StringBuilder();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    builder.append(line).append("\n");
                }
                JSONTokener tokener = new JSONTokener(builder.toString());
                JSONObject rootObject = new JSONObject(tokener);
                JSONObject responseObject = (JSONObject)rootObject.get("response");
                int numFound = (Integer)responseObject.get("numFound");
                if (numFound == 0) {
                    return null;
                }
                if (numFound == 1) {
                    JSONArray docs = (JSONArray)responseObject.get("docs");
                    JSONObject firstHit = (JSONObject)docs.get(0);
                    MavenArtifact artifactMetadata = new MavenArtifact();
                    artifactMetadata.setGroupId((String)firstHit.get("g"));
                    artifactMetadata.setArtifactId((String)firstHit.get("a"));
                    artifactMetadata.setVersion((String)firstHit.get("v"));
                    artifactMetadata.setPackaging((String)firstHit.get("p"));
                    return artifactMetadata;
                }
                long newestTimestamp = 0L;
                JSONObject newestVersion = null;
                JSONArray options = (JSONArray)responseObject.get("docs");
                for (int i = 0; i < numFound; ++i) {
                    long timestamp;
                    JSONObject option = (JSONObject)options.get(0);
                    if (!"batik".equals(option.get("g")) || !"batik-dom".equals(option.get("a")) || !"jar".equals(option.get("p")) || (timestamp = ((Long)option.get("timestamp")).longValue()) <= newestTimestamp) continue;
                    newestTimestamp = timestamp;
                    newestVersion = option;
                }
                if (newestVersion != null) {
                    MavenArtifact artifactMetadata = new MavenArtifact();
                    artifactMetadata.setGroupId((String)newestVersion.get("g"));
                    artifactMetadata.setArtifactId((String)newestVersion.get("a"));
                    artifactMetadata.setVersion((String)newestVersion.get("v"));
                    artifactMetadata.setPackaging((String)newestVersion.get("p"));
                    return artifactMetadata;
                }
                LOG.warn("For jar-file with checksum: " + checksum + " more than one result was returned by query: " + MAVEN_CENTRAL_SHA_1_QUERY_URL + checksum);
            }
            catch (IOException e) {
                throw new ConverterException("Error processing Metadata for checksum: '" + checksum + "'", e);
            }
            catch (JSONException e) {
                throw new ConverterException("Error processing Metadata for checksum: '" + checksum + "'", e);
            }
        }
        return null;
    }

    protected void copyFile(File source, File target) throws ConverterException {
        try {
            int len;
            File outputDirectory = target.getParentFile();
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new ConverterException("Could not create directory: " + outputDirectory.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(target);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new ConverterException("Error copying file from '" + source.getPath() + "' to '" + target.getPath() + "'", e);
        }
    }

    protected void writePomArtifact(MavenArtifact pomData) throws ConverterException {
        File outputFile = pomData.getPomTargetFile(this.rootTargetDirectory);
        this.createPomDocument(pomData, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPomDocument(MavenArtifact metadata, File outputFile) throws ConverterException {
        try {
            HashMap<String, MavenArtifact> freemarkerContext = new HashMap<String, MavenArtifact>();
            freemarkerContext.put("artifact", metadata);
            URL check = this.getClass().getClassLoader().getResource("templates/" + metadata.getPackaging() + ".ftl");
            Template template = check != null ? this.freemarkerConfig.getTemplate("templates/" + metadata.getPackaging() + ".ftl") : this.freemarkerConfig.getTemplate("templates/default.ftl");
            OutputStreamWriter writer = null;
            try {
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    throw new ConverterException("Could not create template output directory.");
                }
                writer = new FileWriter(outputFile);
                template.process(freemarkerContext, (Writer)writer);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            throw new ConverterException("Error generating template output.", e);
        }
    }

    protected void writeDummy(File targetFile) throws ConverterException {
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targetFile));
            out.putNextEntry(new ZipEntry("dummy"));
            out.closeEntry();
            out.close();
        }
        catch (IOException e) {
            throw new ConverterException("Error generating dummy resouce bundle.");
        }
    }

    protected MavenArtifact resolveArtifact(File sourceFile, String defaultGroupId, String defaultVersion) throws ConverterException {
        String checksum = this.calculateChecksum(sourceFile);
        MavenArtifact artifact = this.checksums.get(checksum);
        if (artifact != null) {
            LOG.info("Reusing artifact (" + checksum + ") : " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion());
            return artifact;
        }
        artifact = this.lookupMetadataForChecksum(checksum);
        if (artifact != null) {
            LOG.info("Using artifact from Maven Central (" + checksum + ") : " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion());
        } else {
            String artifactFileName = sourceFile.getName();
            String dependencyArtifactId = artifactFileName.substring(0, artifactFileName.lastIndexOf("."));
            String dependencyArtifactPackaging = artifactFileName.substring(artifactFileName.lastIndexOf(".") + 1);
            artifact = new MavenArtifact();
            artifact.setGroupId(defaultGroupId);
            artifact.setArtifactId(dependencyArtifactId);
            artifact.setVersion(defaultVersion);
            artifact.setPackaging(dependencyArtifactPackaging);
            artifact.addDefaultBinaryArtifact(sourceFile);
            this.writeArtifact(artifact);
        }
        this.checksums.put(checksum, artifact);
        return artifact;
    }

    protected void writeArtifact(MavenArtifact artifact) throws ConverterException {
        this.writePomArtifact(artifact);
        List<String> binaryClassifiers = artifact.getBinaryFilesClassifiers();
        for (String classifier : binaryClassifiers) {
            File binarySourceFile = artifact.getBinarySourceFile(classifier);
            File binaryTargetFile = artifact.getBinaryTargetFile(this.rootTargetDirectory, classifier);
            this.copyFile(binarySourceFile, binaryTargetFile);
        }
    }

    protected void generateZip(File[] sourceFiles, File targetFile) throws ConverterException {
        if (sourceFiles == null || sourceFiles.length == 0) {
            return;
        }
        File rootDir = sourceFiles[0].getParentFile();
        this.generateZip(rootDir, sourceFiles, targetFile);
    }

    protected void generateZip(File rootDir, File[] sourceFiles, File targetFile) throws ConverterException {
        if (sourceFiles == null || sourceFiles.length == 0) {
            return;
        }
        File[] zipInputFiles = new File[sourceFiles.length];
        System.arraycopy(sourceFiles, 0, zipInputFiles, 0, sourceFiles.length);
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(targetFile));
            for (File file : zipInputFiles) {
                this.addFileToZip(zipOutputStream, file, rootDir);
            }
            zipOutputStream.close();
        }
        catch (IOException e) {
            throw new ConverterException("Error generating " + targetFile.getName() + " zip.", e);
        }
    }

    protected void addFileToZip(ZipOutputStream zipOutputStream, File inputFile, File rootDirectory) throws ConverterException {
        block6: {
            block5: {
                if (inputFile == null) {
                    return;
                }
                if (!inputFile.isDirectory()) break block5;
                File[] directoryContent = inputFile.listFiles();
                if (directoryContent == null) break block6;
                for (File file : directoryContent) {
                    this.addFileToZip(zipOutputStream, file, rootDirectory);
                }
                break block6;
            }
            byte[] buf = new byte[1024];
            try {
                int len;
                FileInputStream in = new FileInputStream(inputFile);
                String zipPath = inputFile.getAbsolutePath().substring(rootDirectory.getAbsolutePath().length() + 1).replace("\\", "/");
                zipOutputStream.putNextEntry(new ZipEntry(zipPath));
                while ((len = in.read(buf)) > 0) {
                    zipOutputStream.write(buf, 0, len);
                }
                zipOutputStream.closeEntry();
                in.close();
            }
            catch (IOException e) {
                throw new ConverterException("Error adding files to zip.", e);
            }
        }
    }

    protected String getFlexVersion(File rootDirectory) throws ConverterException {
        File sdkDescriptor = new File(rootDirectory, "flex-sdk-description.xml");
        if (!sdkDescriptor.exists()) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(sdkDescriptor);
            Element root = dom.getDocumentElement();
            String version = root.getElementsByTagName("version").item(0).getTextContent();
            String build = root.getElementsByTagName("build").item(0).getTextContent();
            return build.equals("0") ? version + "-SNAPSHOT" : version;
        }
        catch (ParserConfigurationException pce) {
            throw new ConverterException("Error parsing flex-sdk-description.xml", pce);
        }
        catch (SAXException se) {
            throw new ConverterException("Error parsing flex-sdk-description.xml", se);
        }
        catch (IOException ioe) {
            throw new ConverterException("Error parsing flex-sdk-description.xml", ioe);
        }
    }

    protected Collection<File> listAllFiles(File source, FileFilter filter) {
        File[] dirContent;
        if (filter.accept(source)) {
            return Collections.singleton(source);
        }
        if (source.isDirectory() && (dirContent = source.listFiles()) != null) {
            LinkedList<File> filteredContent = new LinkedList<File>();
            for (File child : dirContent) {
                filteredContent.addAll(this.listAllFiles(child, filter));
            }
            return filteredContent;
        }
        return Collections.emptyList();
    }
}

