/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.tooling.model.BaseOptionModel;

public final class PropertyConfigurerGenerator {
    private PropertyConfigurerGenerator() {
    }

    public static void generatePropertyConfigurer(String pn, String cn, String en, String pfqn, String psn, boolean hasSuper, boolean component, Collection<? extends BaseOptionModel> options, Writer w) throws IOException {
        w.write("/* Generated by camel build tools - do NOT edit this file! */\n");
        w.write("package " + pn + ";\n");
        w.write("\n");
        w.write("import java.util.Map;\n");
        w.write("\n");
        w.write("import org.apache.camel.CamelContext;\n");
        w.write("import org.apache.camel.spi.GeneratedPropertyConfigurer;\n");
        w.write("import org.apache.camel.spi.PropertyConfigurerGetter;\n");
        w.write("import org.apache.camel.util.CaseInsensitiveMap;\n");
        w.write("import " + pfqn + ";\n");
        w.write("\n");
        w.write("/**\n");
        w.write(" * Generated by camel build tools - do NOT edit this file!\n");
        w.write(" */\n");
        w.write("@SuppressWarnings(\"unchecked\")\n");
        w.write("public class " + cn + " extends " + psn + " implements GeneratedPropertyConfigurer, PropertyConfigurerGetter {\n");
        w.write("\n");
        if (!options.isEmpty() || !hasSuper) {
            String getOrSet;
            Optional<? extends BaseOptionModel> configurationOption;
            options = options.stream().sorted(Comparator.comparing(BaseOptionModel::getName)).collect(Collectors.toList());
            if (component && (configurationOption = PropertyConfigurerGenerator.findConfiguration(options)).isPresent()) {
                w.write(PropertyConfigurerGenerator.createGetOrCreateConfiguration(en, configurationOption.get().getConfigurationClass(), configurationOption.get().getConfigurationField()));
                w.write("\n");
            }
            w.write("    @Override\n");
            w.write("    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.write("        " + en + " target = (" + en + ") obj;\n");
                w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    getOrSet = option.getName();
                    getOrSet = Character.toUpperCase(getOrSet.charAt(0)) + getOrSet.substring(1);
                    String setterLambda = PropertyConfigurerGenerator.setterLambda(getOrSet, option.getJavaType(), option.getSetterMethod(), option.getConfigurationField(), component, option.getType());
                    if (!option.getName().toLowerCase().equals(option.getName())) {
                        w.write(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.write(String.format("        case \"%s\": %s; return true;\n", option.getName(), setterLambda));
                }
                if (hasSuper) {
                    w.write("        default: return super.configure(camelContext, obj, name, value, ignoreCase);\n");
                } else {
                    w.write("        default: return false;\n");
                }
                w.write("        }\n");
            }
            w.write("    }\n");
            w.write("\n");
            w.write("    @Override\n");
            w.write("    public Map<String, Object> getAllOptions(Object target) {\n");
            if (hasSuper) {
                w.write("        Map<String, Object> answer = super.getAllOptions(target);\n");
            } else {
                w.write("        Map<String, Object> answer = new CaseInsensitiveMap();\n");
            }
            if (!options.isEmpty() || !hasSuper) {
                for (BaseOptionModel option : options) {
                    String type = option.getJavaType();
                    if (type.indexOf(60) != -1) {
                        type = type.substring(0, type.indexOf(60));
                    }
                    type = type.replace('$', '.');
                    w.write(String.format("        answer.put(\"%s\", %s.class);\n", option.getName(), type));
                }
                w.write("        return answer;\n");
                w.write("    }\n");
            }
            w.write("\n");
            w.write("    @Override\n");
            w.write("    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.write("        " + en + " target = (" + en + ") obj;\n");
                w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    getOrSet = option.getName();
                    getOrSet = Character.toUpperCase(getOrSet.charAt(0)) + getOrSet.substring(1);
                    String getterLambda = PropertyConfigurerGenerator.getterLambda(getOrSet, option.getJavaType(), option.getGetterMethod(), option.getConfigurationField(), component);
                    if (!option.getName().toLowerCase().equals(option.getName())) {
                        w.write(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.write(String.format("        case \"%s\": return %s;\n", option.getName(), getterLambda));
                }
                if (hasSuper) {
                    w.write("        default: return super.getOptionValue(obj, name, ignoreCase);\n");
                } else {
                    w.write("        default: return null;\n");
                }
                w.write("        }\n");
            }
            w.write("    }\n");
        }
        w.write("}\n");
        w.write("\n");
    }

    private static Optional<? extends BaseOptionModel> findConfiguration(Collection<? extends BaseOptionModel> options) {
        return options.stream().filter(o -> o.getConfigurationField() != null).findFirst();
    }

    private static String setterLambda(String getOrSet, String type, String setterMethod, String configurationField, boolean component, String optionKind) {
        if (type.indexOf(60) != -1) {
            type = type.substring(0, type.indexOf(60));
        }
        type = type.replace('$', '.');
        getOrSet = configurationField != null ? (component ? "getOrCreateConfiguration(target).set" + getOrSet : "target.get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1) + "().set" + getOrSet) : "target.set" + getOrSet;
        String rv = "duration".equals(optionKind) && "long".equals(type) ? "property(camelContext, java.time.Duration.class, value).toMillis()" : String.format("property(camelContext, %s.class, value)", type);
        String v = setterMethod != null ? String.format(setterMethod, rv) : rv;
        return String.format("%s(%s)", getOrSet, v);
    }

    private static String getterLambda(String getOrSet, String type, String getterMethod, String configurationField, boolean component) {
        String prefix;
        if (getterMethod == null || getterMethod.isEmpty()) {
            prefix = "boolean".equals(type) ? "is" : "get";
        } else {
            prefix = "";
            getOrSet = getterMethod;
        }
        getOrSet = configurationField != null ? (component ? "getOrCreateConfiguration(target)." + prefix + getOrSet : "target.get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1) + "()." + prefix + getOrSet) : "target." + prefix + getOrSet;
        return getOrSet + "()";
    }

    private static String createGetOrCreateConfiguration(String targetClass, String configurationClass, String configurationField) {
        String getter = "get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        String setter = "set" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        StringBuilder sb = new StringBuilder();
        String line1 = String.format("    private %s getOrCreateConfiguration(%s target) {\n", configurationClass, targetClass);
        String line2 = String.format("        if (target.%s() == null) {\n", getter);
        String line3 = String.format("            target.%s(new %s());\n", setter, configurationClass);
        String line4 = String.format("        }\n", new Object[0]);
        String line5 = String.format("        return target.%s();\n", getter);
        String line6 = String.format("    }\n", new Object[0]);
        sb.append(line1).append(line2).append(line3).append(line4).append(line5).append(line6);
        return sb.toString();
    }
}

