/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.base;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.http.base.HttpSendDynamicPostProcessor;
import org.apache.camel.http.base.HttpSendDynamicPreProcessor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class HttpSendDynamicAware
implements SendDynamicAware {
    private final Processor postProcessor = new HttpSendDynamicPostProcessor();
    private String scheme;

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        RuntimeCamelCatalog catalog = ((ExtendedCamelContext)exchange.getContext().adapt(ExtendedCamelContext.class)).getRuntimeCamelCatalog();
        Map properties = catalog.endpointProperties(uri);
        Map lenient = catalog.endpointLenientProperties(uri);
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, properties, lenient);
    }

    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String[] hostAndPath = this.parseUri(entry);
        String host = hostAndPath[0];
        String path = hostAndPath[1];
        if (path != null || !entry.getLenientProperties().isEmpty()) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(entry.getProperties());
            for (String k : entry.getLenientProperties().keySet()) {
                params.remove(k);
            }
            if (path != null) {
                if (params.containsKey("httpUri")) {
                    params.put("httpUri", host);
                } else if (params.containsKey("httpURI")) {
                    params.put("httpURI", host);
                } else if ("netty-http".equals(this.scheme)) {
                    params.remove("path");
                }
            }
            RuntimeCamelCatalog catalog = ((ExtendedCamelContext)exchange.getContext().adapt(ExtendedCamelContext.class)).getRuntimeCamelCatalog();
            return catalog.asEndpointUri(this.scheme, params, false);
        }
        return null;
    }

    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String[] hostAndPath = this.parseUri(entry);
        String path = hostAndPath[1];
        String query = null;
        if (!entry.getLenientProperties().isEmpty()) {
            query = URISupport.createQueryString(new LinkedHashMap(entry.getLenientProperties()));
        }
        if (path != null || query != null) {
            return new HttpSendDynamicPreProcessor(path, query);
        }
        return null;
    }

    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return this.postProcessor;
    }

    public String[] parseUri(SendDynamicAware.DynamicAwareEntry entry) {
        boolean httpComponent;
        String u = entry.getUri();
        boolean bl = httpComponent = "http".equals(this.scheme) || "https".equals(this.scheme);
        if (!httpComponent) {
            String prefix = this.scheme + "://";
            String prefix2 = this.scheme + ":";
            if (u.startsWith(prefix)) {
                u = u.substring(prefix.length());
            } else if (u.startsWith(prefix2)) {
                u = u.substring(prefix2.length());
            }
        }
        if (u.indexOf(63) > 0) {
            u = StringHelper.before((String)u, (String)"?");
        }
        try {
            URI parse = new URI(u);
            String host = parse.getHost();
            String path = parse.getPath();
            if (path != null && path.length() > 1) {
                String scheme;
                int port = parse.getPort();
                if (port > 0 && port != 80 && port != 443) {
                    host = host + ":" + port;
                }
                if (!httpComponent && (scheme = parse.getScheme()) != null) {
                    host = scheme + "://" + host;
                }
                return new String[]{host, path};
            }
        }
        catch (URISyntaxException e) {
            return new String[]{u, null};
        }
        return new String[]{u, null};
    }
}

