/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.component.ehcache.EhcacheEndpoint;
import org.apache.camel.component.ehcache.EhcacheManager;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.HeaderSelectorProducer;
import org.ehcache.Cache;

public class EhcacheProducer
extends HeaderSelectorProducer {
    private final EhcacheConfiguration configuration;
    private final EhcacheManager manager;
    private final Cache cache;

    public EhcacheProducer(EhcacheEndpoint endpoint, String cacheName, EhcacheConfiguration configuration) throws Exception {
        super((Endpoint)endpoint, "CamelEhcacheAction", configuration::getAction);
        this.configuration = configuration;
        this.manager = endpoint.getManager();
        Class kt = null;
        if (configuration.getKeyType() != null) {
            kt = this.getEndpoint().getCamelContext().getClassResolver().resolveClass(configuration.getKeyType());
        }
        Class vt = null;
        if (configuration.getValueType() != null) {
            vt = this.getEndpoint().getCamelContext().getClassResolver().resolveClass(configuration.getValueType());
        }
        this.cache = this.manager.getCache(cacheName, kt, vt);
    }

    @InvokeOnHeader(value="CLEAR")
    public void onClear(Message message) throws Exception {
        this.cache.clear();
        this.setResult(message, true, null, null);
    }

    @InvokeOnHeader(value="PUT")
    public void onPut(Message message) throws Exception {
        this.cache.put(this.getKey(message), this.getValue(message, this.cache.getRuntimeConfiguration().getValueType()));
        this.setResult(message, true, null, null);
    }

    @InvokeOnHeader(value="PUT_ALL")
    public void onPutAll(Message message) throws Exception {
        this.cache.putAll((Map)this.getValue(message, Map.class));
        this.setResult(message, true, null, null);
    }

    @InvokeOnHeader(value="PUT_IF_ABSENT")
    public void onPutIfAbsent(Message message) throws Exception {
        Object oldValue = this.cache.putIfAbsent(this.getKey(message), this.getValue(message, this.cache.getRuntimeConfiguration().getValueType()));
        this.setResult(message, true, null, oldValue);
    }

    @InvokeOnHeader(value="GET")
    public void onGet(Message message) throws Exception {
        Object result = this.cache.get(this.getKey(message));
        this.setResult(message, true, result, null);
    }

    @InvokeOnHeader(value="GET_ALL")
    public void onGetAll(Message message) throws Exception {
        Map result = this.cache.getAll((Set)message.getHeader("CamelEhcacheKeys", Collections::emptySet, Set.class));
        this.setResult(message, true, result, null);
    }

    @InvokeOnHeader(value="REMOVE")
    public void onRemove(Message message) throws Exception {
        boolean success = true;
        Object valueToReplace = message.getHeader("CamelEhcacheOldValue");
        if (valueToReplace == null) {
            this.cache.remove(this.getKey(message));
        } else {
            success = this.cache.remove(this.getKey(message), valueToReplace);
        }
        this.setResult(message, success, null, null);
    }

    @InvokeOnHeader(value="REMOVE_ALL")
    public void onRemoveAll(Message message) throws Exception {
        this.cache.removeAll((Set)message.getHeader("CamelEhcacheKeys", Collections::emptySet, Set.class));
        this.setResult(message, true, null, null);
    }

    @InvokeOnHeader(value="REPLACE")
    public void onReplace(Message message) throws Exception {
        boolean success = true;
        Object oldValue = null;
        Object value = this.getValue(message, this.cache.getRuntimeConfiguration().getValueType());
        Object valueToReplace = message.getHeader("CamelEhcacheOldValue");
        if (valueToReplace == null) {
            oldValue = this.cache.replace(this.getKey(message), value);
        } else {
            success = this.cache.replace(this.getKey(message), valueToReplace, value);
        }
        this.setResult(message, success, null, oldValue);
    }

    private Object getKey(Message message) throws Exception {
        Object value;
        if (this.configuration.getKeyType() != null) {
            Class clazz = this.getEndpoint().getCamelContext().getClassResolver().resolveClass(this.configuration.getKeyType());
            value = message.getHeader("CamelEhcacheKey", clazz);
        } else {
            value = message.getHeader("CamelEhcacheKey");
        }
        if (value == null) {
            value = this.configuration.getKey();
        }
        if (value == null) {
            throw new CamelExchangeException("No value provided in header or as default value (CamelEhcacheKey)", message.getExchange());
        }
        return value;
    }

    private Object getValue(Message message, Object type) throws Exception {
        Object value = message.getHeader("CamelEhcacheValue");
        if (value == null) {
            if (type instanceof String) {
                Class clazz = this.getEndpoint().getCamelContext().getClassResolver().resolveClass((String)type);
                value = message.getBody(clazz);
            } else {
                value = type instanceof Class ? message.getBody((Class)type) : message.getBody();
            }
        }
        if (value == null) {
            throw new CamelExchangeException("No value provided in header or body (CamelEhcacheValue)", message.getExchange());
        }
        return value;
    }

    private void setResult(Message message, boolean success, Object result, Object oldValue) {
        message.setHeader("CamelEhcacheActionSucceeded", (Object)success);
        message.setHeader("CamelEhcacheActionHasResult", (Object)(oldValue != null || result != null ? 1 : 0));
        if (oldValue != null) {
            message.setHeader("CamelEhcacheOldValue", oldValue);
        }
        if (result != null) {
            message.setBody(result);
        }
    }
}

