/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public interface JmsComponentBuilderFactory {
    public static JmsComponentBuilder jms() {
        return new JmsComponentBuilderImpl();
    }

    public static class JmsComponentBuilderImpl
    extends AbstractComponentBuilder<JmsComponent>
    implements JmsComponentBuilder {
        @Override
        protected JmsComponent buildConcreteComponent() {
            return new JmsComponent();
        }

        private JmsConfiguration getOrCreateConfiguration(JmsComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new JmsConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "clientId": {
                    this.getOrCreateConfiguration((JmsComponent)component).setClientId((String)value);
                    return true;
                }
                case "connectionFactory": {
                    this.getOrCreateConfiguration((JmsComponent)component).setConnectionFactory((ConnectionFactory)value);
                    return true;
                }
                case "disableReplyTo": {
                    this.getOrCreateConfiguration((JmsComponent)component).setDisableReplyTo(((Boolean)value).booleanValue());
                    return true;
                }
                case "durableSubscriptionName": {
                    this.getOrCreateConfiguration((JmsComponent)component).setDurableSubscriptionName((String)value);
                    return true;
                }
                case "jmsMessageType": {
                    this.getOrCreateConfiguration((JmsComponent)component).setJmsMessageType((JmsMessageType)value);
                    return true;
                }
                case "testConnectionOnStartup": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTestConnectionOnStartup(((Boolean)value).booleanValue());
                    return true;
                }
                case "acknowledgementModeName": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAcknowledgementModeName((String)value);
                    return true;
                }
                case "asyncConsumer": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAsyncConsumer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoStartup": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAutoStartup(((Boolean)value).booleanValue());
                    return true;
                }
                case "cacheLevel": {
                    this.getOrCreateConfiguration((JmsComponent)component).setCacheLevel(((Integer)value).intValue());
                    return true;
                }
                case "cacheLevelName": {
                    this.getOrCreateConfiguration((JmsComponent)component).setCacheLevelName((String)value);
                    return true;
                }
                case "concurrentConsumers": {
                    this.getOrCreateConfiguration((JmsComponent)component).setConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "maxConcurrentConsumers": {
                    this.getOrCreateConfiguration((JmsComponent)component).setMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyTo": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyTo((String)value);
                    return true;
                }
                case "replyToDeliveryPersistent": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToDeliveryPersistent(((Boolean)value).booleanValue());
                    return true;
                }
                case "selector": {
                    this.getOrCreateConfiguration((JmsComponent)component).setSelector((String)value);
                    return true;
                }
                case "subscriptionDurable": {
                    this.getOrCreateConfiguration((JmsComponent)component).setSubscriptionDurable(((Boolean)value).booleanValue());
                    return true;
                }
                case "subscriptionName": {
                    this.getOrCreateConfiguration((JmsComponent)component).setSubscriptionName((String)value);
                    return true;
                }
                case "subscriptionShared": {
                    this.getOrCreateConfiguration((JmsComponent)component).setSubscriptionShared(((Boolean)value).booleanValue());
                    return true;
                }
                case "acceptMessagesWhileStopping": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAcceptMessagesWhileStopping(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowReplyManagerQuickStop": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAllowReplyManagerQuickStop(((Boolean)value).booleanValue());
                    return true;
                }
                case "consumerType": {
                    this.getOrCreateConfiguration((JmsComponent)component).setConsumerType((ConsumerType)value);
                    return true;
                }
                case "defaultTaskExecutorType": {
                    this.getOrCreateConfiguration((JmsComponent)component).setDefaultTaskExecutorType((DefaultTaskExecutorType)value);
                    return true;
                }
                case "eagerLoadingOfProperties": {
                    this.getOrCreateConfiguration((JmsComponent)component).setEagerLoadingOfProperties(((Boolean)value).booleanValue());
                    return true;
                }
                case "eagerPoisonBody": {
                    this.getOrCreateConfiguration((JmsComponent)component).setEagerPoisonBody((String)value);
                    return true;
                }
                case "exposeListenerSession": {
                    this.getOrCreateConfiguration((JmsComponent)component).setExposeListenerSession(((Boolean)value).booleanValue());
                    return true;
                }
                case "replyToSameDestinationAllowed": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToSameDestinationAllowed(((Boolean)value).booleanValue());
                    return true;
                }
                case "taskExecutor": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTaskExecutor((TaskExecutor)value);
                    return true;
                }
                case "deliveryDelay": {
                    this.getOrCreateConfiguration((JmsComponent)component).setDeliveryDelay(((Long)value).longValue());
                    return true;
                }
                case "deliveryMode": {
                    this.getOrCreateConfiguration((JmsComponent)component).setDeliveryMode((Integer)value);
                    return true;
                }
                case "deliveryPersistent": {
                    this.getOrCreateConfiguration((JmsComponent)component).setDeliveryPersistent(((Boolean)value).booleanValue());
                    return true;
                }
                case "explicitQosEnabled": {
                    this.getOrCreateConfiguration((JmsComponent)component).setExplicitQosEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "formatDateHeadersToIso8601": {
                    this.getOrCreateConfiguration((JmsComponent)component).setFormatDateHeadersToIso8601(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((JmsComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "preserveMessageQos": {
                    this.getOrCreateConfiguration((JmsComponent)component).setPreserveMessageQos(((Boolean)value).booleanValue());
                    return true;
                }
                case "priority": {
                    this.getOrCreateConfiguration((JmsComponent)component).setPriority(((Integer)value).intValue());
                    return true;
                }
                case "replyToConcurrentConsumers": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToMaxConcurrentConsumers": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToOnTimeoutMaxConcurrentConsumers": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToOnTimeoutMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToOverride": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToOverride((String)value);
                    return true;
                }
                case "replyToType": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToType((ReplyToType)value);
                    return true;
                }
                case "requestTimeout": {
                    this.getOrCreateConfiguration((JmsComponent)component).setRequestTimeout(((Long)value).longValue());
                    return true;
                }
                case "timeToLive": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTimeToLive(((Long)value).longValue());
                    return true;
                }
                case "allowAdditionalHeaders": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAllowAdditionalHeaders((String)value);
                    return true;
                }
                case "allowNullBody": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAllowNullBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "alwaysCopyMessage": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAlwaysCopyMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "correlationProperty": {
                    this.getOrCreateConfiguration((JmsComponent)component).setCorrelationProperty((String)value);
                    return true;
                }
                case "disableTimeToLive": {
                    this.getOrCreateConfiguration((JmsComponent)component).setDisableTimeToLive(((Boolean)value).booleanValue());
                    return true;
                }
                case "forceSendOriginalMessage": {
                    this.getOrCreateConfiguration((JmsComponent)component).setForceSendOriginalMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeSentJMSMessageID": {
                    this.getOrCreateConfiguration((JmsComponent)component).setIncludeSentJMSMessageID(((Boolean)value).booleanValue());
                    return true;
                }
                case "replyToCacheLevelName": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToCacheLevelName((String)value);
                    return true;
                }
                case "replyToDestinationSelectorName": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReplyToDestinationSelectorName((String)value);
                    return true;
                }
                case "streamMessageTypeEnabled": {
                    this.getOrCreateConfiguration((JmsComponent)component).setStreamMessageTypeEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowAutoWiredConnectionFactory": {
                    ((JmsComponent)component).setAllowAutoWiredConnectionFactory(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowAutoWiredDestinationResolver": {
                    ((JmsComponent)component).setAllowAutoWiredDestinationResolver(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowSerializedHeaders": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAllowSerializedHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "artemisStreamingEnabled": {
                    this.getOrCreateConfiguration((JmsComponent)component).setArtemisStreamingEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "asyncStartListener": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAsyncStartListener(((Boolean)value).booleanValue());
                    return true;
                }
                case "asyncStopListener": {
                    this.getOrCreateConfiguration((JmsComponent)component).setAsyncStopListener(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((JmsComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((JmsComponent)component).setConfiguration((JmsConfiguration)value);
                    return true;
                }
                case "destinationResolver": {
                    this.getOrCreateConfiguration((JmsComponent)component).setDestinationResolver((DestinationResolver)value);
                    return true;
                }
                case "errorHandler": {
                    this.getOrCreateConfiguration((JmsComponent)component).setErrorHandler((ErrorHandler)value);
                    return true;
                }
                case "exceptionListener": {
                    this.getOrCreateConfiguration((JmsComponent)component).setExceptionListener((ExceptionListener)value);
                    return true;
                }
                case "idleConsumerLimit": {
                    this.getOrCreateConfiguration((JmsComponent)component).setIdleConsumerLimit(((Integer)value).intValue());
                    return true;
                }
                case "idleTaskExecutionLimit": {
                    this.getOrCreateConfiguration((JmsComponent)component).setIdleTaskExecutionLimit(((Integer)value).intValue());
                    return true;
                }
                case "includeAllJMSXProperties": {
                    this.getOrCreateConfiguration((JmsComponent)component).setIncludeAllJMSXProperties(((Boolean)value).booleanValue());
                    return true;
                }
                case "jmsKeyFormatStrategy": {
                    this.getOrCreateConfiguration((JmsComponent)component).setJmsKeyFormatStrategy((JmsKeyFormatStrategy)value);
                    return true;
                }
                case "mapJmsMessage": {
                    this.getOrCreateConfiguration((JmsComponent)component).setMapJmsMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxMessagesPerTask": {
                    this.getOrCreateConfiguration((JmsComponent)component).setMaxMessagesPerTask(((Integer)value).intValue());
                    return true;
                }
                case "messageConverter": {
                    this.getOrCreateConfiguration((JmsComponent)component).setMessageConverter((MessageConverter)value);
                    return true;
                }
                case "messageCreatedStrategy": {
                    this.getOrCreateConfiguration((JmsComponent)component).setMessageCreatedStrategy((MessageCreatedStrategy)value);
                    return true;
                }
                case "messageIdEnabled": {
                    this.getOrCreateConfiguration((JmsComponent)component).setMessageIdEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "messageListenerContainerFactory": {
                    this.getOrCreateConfiguration((JmsComponent)component).setMessageListenerContainerFactory((MessageListenerContainerFactory)value);
                    return true;
                }
                case "messageTimestampEnabled": {
                    this.getOrCreateConfiguration((JmsComponent)component).setMessageTimestampEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "pubSubNoLocal": {
                    this.getOrCreateConfiguration((JmsComponent)component).setPubSubNoLocal(((Boolean)value).booleanValue());
                    return true;
                }
                case "queueBrowseStrategy": {
                    ((JmsComponent)component).setQueueBrowseStrategy((QueueBrowseStrategy)value);
                    return true;
                }
                case "receiveTimeout": {
                    this.getOrCreateConfiguration((JmsComponent)component).setReceiveTimeout(((Long)value).longValue());
                    return true;
                }
                case "recoveryInterval": {
                    this.getOrCreateConfiguration((JmsComponent)component).setRecoveryInterval(((Long)value).longValue());
                    return true;
                }
                case "requestTimeoutCheckerInterval": {
                    this.getOrCreateConfiguration((JmsComponent)component).setRequestTimeoutCheckerInterval(((Long)value).longValue());
                    return true;
                }
                case "transferException": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTransferException(((Boolean)value).booleanValue());
                    return true;
                }
                case "transferExchange": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTransferExchange(((Boolean)value).booleanValue());
                    return true;
                }
                case "useMessageIDAsCorrelationID": {
                    this.getOrCreateConfiguration((JmsComponent)component).setUseMessageIDAsCorrelationID(((Boolean)value).booleanValue());
                    return true;
                }
                case "waitForProvisionCorrelationToBeUpdatedCounter": {
                    this.getOrCreateConfiguration((JmsComponent)component).setWaitForProvisionCorrelationToBeUpdatedCounter(((Integer)value).intValue());
                    return true;
                }
                case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                    this.getOrCreateConfiguration((JmsComponent)component).setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(((Long)value).longValue());
                    return true;
                }
                case "headerFilterStrategy": {
                    ((JmsComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "errorHandlerLoggingLevel": {
                    this.getOrCreateConfiguration((JmsComponent)component).setErrorHandlerLoggingLevel((LoggingLevel)value);
                    return true;
                }
                case "errorHandlerLogStackTrace": {
                    this.getOrCreateConfiguration((JmsComponent)component).setErrorHandlerLogStackTrace(((Boolean)value).booleanValue());
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((JmsComponent)component).setPassword((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((JmsComponent)component).setUsername((String)value);
                    return true;
                }
                case "transacted": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTransacted(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyCreateTransactionManager": {
                    this.getOrCreateConfiguration((JmsComponent)component).setLazyCreateTransactionManager(((Boolean)value).booleanValue());
                    return true;
                }
                case "transactionManager": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTransactionManager((PlatformTransactionManager)value);
                    return true;
                }
                case "transactionName": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTransactionName((String)value);
                    return true;
                }
                case "transactionTimeout": {
                    this.getOrCreateConfiguration((JmsComponent)component).setTransactionTimeout(((Integer)value).intValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface JmsComponentBuilder
    extends ComponentBuilder<JmsComponent> {
        default public JmsComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public JmsComponentBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public JmsComponentBuilder disableReplyTo(boolean disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        default public JmsComponentBuilder durableSubscriptionName(String durableSubscriptionName) {
            this.doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }

        default public JmsComponentBuilder jmsMessageType(JmsMessageType jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        default public JmsComponentBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        default public JmsComponentBuilder acknowledgementModeName(String acknowledgementModeName) {
            this.doSetProperty("acknowledgementModeName", acknowledgementModeName);
            return this;
        }

        default public JmsComponentBuilder asyncConsumer(boolean asyncConsumer) {
            this.doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }

        default public JmsComponentBuilder autoStartup(boolean autoStartup) {
            this.doSetProperty("autoStartup", autoStartup);
            return this;
        }

        default public JmsComponentBuilder cacheLevel(int cacheLevel) {
            this.doSetProperty("cacheLevel", cacheLevel);
            return this;
        }

        default public JmsComponentBuilder cacheLevelName(String cacheLevelName) {
            this.doSetProperty("cacheLevelName", cacheLevelName);
            return this;
        }

        default public JmsComponentBuilder concurrentConsumers(int concurrentConsumers) {
            this.doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }

        default public JmsComponentBuilder maxConcurrentConsumers(int maxConcurrentConsumers) {
            this.doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }

        default public JmsComponentBuilder replyTo(String replyTo) {
            this.doSetProperty("replyTo", replyTo);
            return this;
        }

        default public JmsComponentBuilder replyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
            this.doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }

        default public JmsComponentBuilder selector(String selector) {
            this.doSetProperty("selector", selector);
            return this;
        }

        default public JmsComponentBuilder subscriptionDurable(boolean subscriptionDurable) {
            this.doSetProperty("subscriptionDurable", subscriptionDurable);
            return this;
        }

        default public JmsComponentBuilder subscriptionName(String subscriptionName) {
            this.doSetProperty("subscriptionName", subscriptionName);
            return this;
        }

        default public JmsComponentBuilder subscriptionShared(boolean subscriptionShared) {
            this.doSetProperty("subscriptionShared", subscriptionShared);
            return this;
        }

        default public JmsComponentBuilder acceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
            this.doSetProperty("acceptMessagesWhileStopping", acceptMessagesWhileStopping);
            return this;
        }

        default public JmsComponentBuilder allowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
            this.doSetProperty("allowReplyManagerQuickStop", allowReplyManagerQuickStop);
            return this;
        }

        default public JmsComponentBuilder consumerType(ConsumerType consumerType) {
            this.doSetProperty("consumerType", consumerType);
            return this;
        }

        default public JmsComponentBuilder defaultTaskExecutorType(DefaultTaskExecutorType defaultTaskExecutorType) {
            this.doSetProperty("defaultTaskExecutorType", defaultTaskExecutorType);
            return this;
        }

        default public JmsComponentBuilder eagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
            this.doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }

        default public JmsComponentBuilder eagerPoisonBody(String eagerPoisonBody) {
            this.doSetProperty("eagerPoisonBody", eagerPoisonBody);
            return this;
        }

        default public JmsComponentBuilder exposeListenerSession(boolean exposeListenerSession) {
            this.doSetProperty("exposeListenerSession", exposeListenerSession);
            return this;
        }

        default public JmsComponentBuilder replyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
            this.doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }

        default public JmsComponentBuilder taskExecutor(TaskExecutor taskExecutor) {
            this.doSetProperty("taskExecutor", taskExecutor);
            return this;
        }

        default public JmsComponentBuilder deliveryDelay(long deliveryDelay) {
            this.doSetProperty("deliveryDelay", deliveryDelay);
            return this;
        }

        default public JmsComponentBuilder deliveryMode(Integer deliveryMode) {
            this.doSetProperty("deliveryMode", deliveryMode);
            return this;
        }

        default public JmsComponentBuilder deliveryPersistent(boolean deliveryPersistent) {
            this.doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }

        default public JmsComponentBuilder explicitQosEnabled(Boolean explicitQosEnabled) {
            this.doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }

        default public JmsComponentBuilder formatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
            this.doSetProperty("formatDateHeadersToIso8601", formatDateHeadersToIso8601);
            return this;
        }

        default public JmsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public JmsComponentBuilder preserveMessageQos(boolean preserveMessageQos) {
            this.doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }

        default public JmsComponentBuilder priority(int priority) {
            this.doSetProperty("priority", priority);
            return this;
        }

        default public JmsComponentBuilder replyToConcurrentConsumers(int replyToConcurrentConsumers) {
            this.doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }

        default public JmsComponentBuilder replyToMaxConcurrentConsumers(int replyToMaxConcurrentConsumers) {
            this.doSetProperty("replyToMaxConcurrentConsumers", replyToMaxConcurrentConsumers);
            return this;
        }

        default public JmsComponentBuilder replyToOnTimeoutMaxConcurrentConsumers(int replyToOnTimeoutMaxConcurrentConsumers) {
            this.doSetProperty("replyToOnTimeoutMaxConcurrentConsumers", replyToOnTimeoutMaxConcurrentConsumers);
            return this;
        }

        default public JmsComponentBuilder replyToOverride(String replyToOverride) {
            this.doSetProperty("replyToOverride", replyToOverride);
            return this;
        }

        default public JmsComponentBuilder replyToType(ReplyToType replyToType) {
            this.doSetProperty("replyToType", replyToType);
            return this;
        }

        default public JmsComponentBuilder requestTimeout(long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public JmsComponentBuilder timeToLive(long timeToLive) {
            this.doSetProperty("timeToLive", timeToLive);
            return this;
        }

        default public JmsComponentBuilder allowAdditionalHeaders(String allowAdditionalHeaders) {
            this.doSetProperty("allowAdditionalHeaders", allowAdditionalHeaders);
            return this;
        }

        default public JmsComponentBuilder allowNullBody(boolean allowNullBody) {
            this.doSetProperty("allowNullBody", allowNullBody);
            return this;
        }

        default public JmsComponentBuilder alwaysCopyMessage(boolean alwaysCopyMessage) {
            this.doSetProperty("alwaysCopyMessage", alwaysCopyMessage);
            return this;
        }

        default public JmsComponentBuilder correlationProperty(String correlationProperty) {
            this.doSetProperty("correlationProperty", correlationProperty);
            return this;
        }

        default public JmsComponentBuilder disableTimeToLive(boolean disableTimeToLive) {
            this.doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }

        default public JmsComponentBuilder forceSendOriginalMessage(boolean forceSendOriginalMessage) {
            this.doSetProperty("forceSendOriginalMessage", forceSendOriginalMessage);
            return this;
        }

        default public JmsComponentBuilder includeSentJMSMessageID(boolean includeSentJMSMessageID) {
            this.doSetProperty("includeSentJMSMessageID", includeSentJMSMessageID);
            return this;
        }

        default public JmsComponentBuilder replyToCacheLevelName(String replyToCacheLevelName) {
            this.doSetProperty("replyToCacheLevelName", replyToCacheLevelName);
            return this;
        }

        default public JmsComponentBuilder replyToDestinationSelectorName(String replyToDestinationSelectorName) {
            this.doSetProperty("replyToDestinationSelectorName", replyToDestinationSelectorName);
            return this;
        }

        default public JmsComponentBuilder streamMessageTypeEnabled(boolean streamMessageTypeEnabled) {
            this.doSetProperty("streamMessageTypeEnabled", streamMessageTypeEnabled);
            return this;
        }

        default public JmsComponentBuilder allowAutoWiredConnectionFactory(boolean allowAutoWiredConnectionFactory) {
            this.doSetProperty("allowAutoWiredConnectionFactory", allowAutoWiredConnectionFactory);
            return this;
        }

        default public JmsComponentBuilder allowAutoWiredDestinationResolver(boolean allowAutoWiredDestinationResolver) {
            this.doSetProperty("allowAutoWiredDestinationResolver", allowAutoWiredDestinationResolver);
            return this;
        }

        default public JmsComponentBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public JmsComponentBuilder artemisStreamingEnabled(boolean artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        default public JmsComponentBuilder asyncStartListener(boolean asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        default public JmsComponentBuilder asyncStopListener(boolean asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        default public JmsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public JmsComponentBuilder configuration(JmsConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public JmsComponentBuilder destinationResolver(DestinationResolver destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        default public JmsComponentBuilder errorHandler(ErrorHandler errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        default public JmsComponentBuilder exceptionListener(ExceptionListener exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        default public JmsComponentBuilder idleConsumerLimit(int idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        default public JmsComponentBuilder idleTaskExecutionLimit(int idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        default public JmsComponentBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        default public JmsComponentBuilder jmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        default public JmsComponentBuilder mapJmsMessage(boolean mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        default public JmsComponentBuilder maxMessagesPerTask(int maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        default public JmsComponentBuilder messageConverter(MessageConverter messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        default public JmsComponentBuilder messageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        default public JmsComponentBuilder messageIdEnabled(boolean messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        default public JmsComponentBuilder messageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        default public JmsComponentBuilder messageTimestampEnabled(boolean messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        default public JmsComponentBuilder pubSubNoLocal(boolean pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        default public JmsComponentBuilder queueBrowseStrategy(QueueBrowseStrategy queueBrowseStrategy) {
            this.doSetProperty("queueBrowseStrategy", queueBrowseStrategy);
            return this;
        }

        default public JmsComponentBuilder receiveTimeout(long receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        default public JmsComponentBuilder recoveryInterval(long recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        default public JmsComponentBuilder requestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        default public JmsComponentBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public JmsComponentBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public JmsComponentBuilder useMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        default public JmsComponentBuilder waitForProvisionCorrelationToBeUpdatedCounter(int waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        default public JmsComponentBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public JmsComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public JmsComponentBuilder errorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
            this.doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }

        default public JmsComponentBuilder errorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
            this.doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }

        default public JmsComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public JmsComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        default public JmsComponentBuilder transacted(boolean transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        default public JmsComponentBuilder lazyCreateTransactionManager(boolean lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        default public JmsComponentBuilder transactionManager(PlatformTransactionManager transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        default public JmsComponentBuilder transactionName(String transactionName) {
            this.doSetProperty("transactionName", transactionName);
            return this;
        }

        default public JmsComponentBuilder transactionTimeout(int transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }
}

