/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.eks.AmazonEKS;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.eks.EKSComponent;
import org.apache.camel.component.aws.eks.EKSConfiguration;
import org.apache.camel.component.aws.eks.EKSOperations;

public interface AwsEksComponentBuilderFactory {
    public static AwsEksComponentBuilder awsEks() {
        return new AwsEksComponentBuilderImpl();
    }

    public static class AwsEksComponentBuilderImpl
    extends AbstractComponentBuilder<EKSComponent>
    implements AwsEksComponentBuilder {
        @Override
        protected EKSComponent buildConcreteComponent() {
            return new EKSComponent();
        }

        private EKSConfiguration getOrCreateConfiguration(EKSComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new EKSConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    this.getOrCreateConfiguration((EKSComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "configuration": {
                    ((EKSComponent)component).setConfiguration((EKSConfiguration)value);
                    return true;
                }
                case "eksClient": {
                    this.getOrCreateConfiguration((EKSComponent)component).setEksClient((AmazonEKS)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((EKSComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((EKSComponent)component).setOperation((EKSOperations)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((EKSComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((EKSComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((EKSComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((EKSComponent)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((EKSComponent)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((EKSComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsEksComponentBuilder
    extends ComponentBuilder<EKSComponent> {
        default public AwsEksComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsEksComponentBuilder configuration(EKSConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsEksComponentBuilder eksClient(AmazonEKS eksClient) {
            this.doSetProperty("eksClient", eksClient);
            return this;
        }

        default public AwsEksComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsEksComponentBuilder operation(EKSOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsEksComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsEksComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsEksComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsEksComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsEksComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsEksComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

