/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.iam.IAM2Component;
import org.apache.camel.component.aws2.iam.IAM2Configuration;
import org.apache.camel.component.aws2.iam.IAM2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.iam.IamClient;

public interface Aws2IamComponentBuilderFactory {
    public static Aws2IamComponentBuilder aws2Iam() {
        return new Aws2IamComponentBuilderImpl();
    }

    public static class Aws2IamComponentBuilderImpl
    extends AbstractComponentBuilder<IAM2Component>
    implements Aws2IamComponentBuilder {
        @Override
        protected IAM2Component buildConcreteComponent() {
            return new IAM2Component();
        }

        private IAM2Configuration getOrCreateConfiguration(IAM2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new IAM2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((IAM2Component)component).setConfiguration((IAM2Configuration)value);
                    return true;
                }
                case "iamClient": {
                    this.getOrCreateConfiguration((IAM2Component)component).setIamClient((IamClient)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((IAM2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((IAM2Component)component).setOperation((IAM2Operations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((IAM2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((IAM2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((IAM2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((IAM2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((IAM2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((IAM2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((IAM2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((IAM2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((IAM2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2IamComponentBuilder
    extends ComponentBuilder<IAM2Component> {
        default public Aws2IamComponentBuilder configuration(IAM2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2IamComponentBuilder iamClient(IamClient iamClient) {
            this.doSetProperty("iamClient", iamClient);
            return this;
        }

        default public Aws2IamComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2IamComponentBuilder operation(IAM2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2IamComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2IamComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2IamComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2IamComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2IamComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2IamComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2IamComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2IamComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2IamComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

