/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.eks.EKS2Component;
import org.apache.camel.component.aws2.eks.EKS2Configuration;
import org.apache.camel.component.aws2.eks.EKS2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.eks.EksClient;

public interface Aws2EksComponentBuilderFactory {
    public static Aws2EksComponentBuilder aws2Eks() {
        return new Aws2EksComponentBuilderImpl();
    }

    public static class Aws2EksComponentBuilderImpl
    extends AbstractComponentBuilder<EKS2Component>
    implements Aws2EksComponentBuilder {
        @Override
        protected EKS2Component buildConcreteComponent() {
            return new EKS2Component();
        }

        private EKS2Configuration getOrCreateConfiguration(EKS2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new EKS2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((EKS2Component)component).setConfiguration((EKS2Configuration)value);
                    return true;
                }
                case "eksClient": {
                    this.getOrCreateConfiguration((EKS2Component)component).setEksClient((EksClient)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((EKS2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((EKS2Component)component).setOperation((EKS2Operations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((EKS2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((EKS2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((EKS2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((EKS2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((EKS2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((EKS2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((EKS2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((EKS2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((EKS2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2EksComponentBuilder
    extends ComponentBuilder<EKS2Component> {
        default public Aws2EksComponentBuilder configuration(EKS2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2EksComponentBuilder eksClient(EksClient eksClient) {
            this.doSetProperty("eksClient", eksClient);
            return this;
        }

        default public Aws2EksComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2EksComponentBuilder operation(EKS2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2EksComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2EksComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2EksComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2EksComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2EksComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2EksComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2EksComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2EksComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2EksComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

