/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.transaction;

import javax.inject.Named;
import javax.transaction.Transaction;
import org.apache.camel.cdi.transaction.TransactionalJtaTransactionPolicy;
import org.apache.camel.jta.JtaTransactionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="PROPAGATION_NESTED")
public class NestedJtaTransactionPolicy
extends TransactionalJtaTransactionPolicy {
    private final Logger logger = LoggerFactory.getLogger((String)NestedJtaTransactionPolicy.class.getCanonicalName());

    public void run(JtaTransactionPolicy.Runnable runnable) throws Throwable {
        Transaction suspendedTransaction = null;
        boolean rollback = false;
        try {
            suspendedTransaction = this.suspendTransaction();
            this.runWithTransaction(runnable, true);
        }
        catch (Throwable e) {
            rollback = true;
            throw e;
        }
        finally {
            try {
                if (rollback) {
                    this.rollback(false);
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not do rollback of outer transaction", (Throwable)e);
            }
            try {
                this.resumeTransaction(suspendedTransaction);
            }
            catch (Exception e) {
                this.logger.warn("Could not resume outer transaction", (Throwable)e);
            }
        }
    }
}

