/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.bundle;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.AnalyzerPlugin;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BndPlugin(name="camel")
public class CamelPlugin
implements AnalyzerPlugin {
    public boolean analyzeJar(Analyzer analyzer) {
        Jar jar = analyzer.getJar();
        Map dir = jar.getDirectories();
        Stream<String> components = dir.getOrDefault("META-INF/services/org/apache/camel/component", Collections.emptyMap()).keySet().stream().map(s -> s.substring(s.lastIndexOf(47) + 1)).map(s -> "osgi.service;effective:=active;objectClass=\"org.apache.camel.spi.ComponentResolver\";component=" + s);
        Stream<String> languages = dir.getOrDefault("META-INF/services/org/apache/camel/language", Collections.emptyMap()).keySet().stream().map(s -> s.substring(s.lastIndexOf(47) + 1)).map(s -> "osgi.service;effective:=active;objectClass=\"org.apache.camel.spi.LanguageResolver\";language=" + s);
        Stream<String> dataformats = dir.getOrDefault("META-INF/services/org/apache/camel/dataformat", Collections.emptyMap()).keySet().stream().map(s -> s.substring(s.lastIndexOf(47) + 1)).map(s -> "osgi.service;effective:=active;objectClass=\"org.apache.camel.spi.DataformatResolver\";dataformat=" + s);
        String header = analyzer.getProperty("Provide-Capability");
        header = Stream.concat(header != null && !header.isEmpty() ? Stream.of(header) : Stream.empty(), Stream.concat(components, Stream.concat(languages, dataformats))).collect(Collectors.joining(","));
        analyzer.setProperty("Provide-Capability", header);
        return false;
    }
}

