/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.security.Provider;
import java.security.Security;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.internal.AS2ApiCollection;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="as2")
public class AS2Component
extends AbstractApiComponent<AS2ApiName, AS2Configuration, AS2ApiCollection> {
    private static final Logger LOG = LoggerFactory.getLogger(AS2Component.class);

    public AS2Component() {
        super(AS2Endpoint.class, AS2ApiName.class, (ApiCollection)AS2ApiCollection.getCollection());
    }

    public AS2Component(CamelContext context) {
        super(context, AS2Endpoint.class, AS2ApiName.class, (ApiCollection)AS2ApiCollection.getCollection());
    }

    protected AS2ApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return AS2ApiName.fromValue(apiNameStr);
    }

    protected Endpoint createEndpoint(String uri, String methodName, AS2ApiName apiName, AS2Configuration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new AS2Endpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (Security.getProvider("BC") == null) {
            LOG.debug("Adding BouncyCastleProvider as security provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

