/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import fr.inra.agrosyst.api.utils.DataValidator;
import fr.inra.agrosyst.web.validators.NuitonFieldValidatorSupport;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FrenchSiretFieldValidator
extends NuitonFieldValidatorSupport {
    protected static final Pattern p = Pattern.compile("[0-9]{3}[\\s]?[0-9]{3}[\\s]?[0-9]{3}[\\s]?[0-9]{5}");

    public void validateWhenNotSkip(Object object) throws ValidationException {
        String siretValue;
        StringBuilder siret;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            siret = new StringBuilder();
            for (int i = 0; i < Array.getLength(value); ++i) {
                siret.append(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            siret = new StringBuilder();
            for (Object o : (Collection)value) {
                siret.append(o);
            }
        } else {
            siret = new StringBuilder(String.valueOf(value));
        }
        if (StringUtils.isBlank((CharSequence)(siretValue = siret.toString()))) {
            return;
        }
        Matcher m = p.matcher(siretValue = StringUtils.deleteWhitespace((String)siretValue));
        if (!m.matches() || !DataValidator.luhnChecksum((String)siretValue)) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "frenchSiret";
    }
}

