/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.filters;

import fr.inra.agrosyst.web.filters.HtmlResponseWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IeEdgeCssFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String userAgent = ((HttpServletRequest)request).getHeader("User-Agent");
        if (userAgent != null && (userAgent.contains("MSIE") || userAgent.contains("Edge") || userAgent.contains("Trident"))) {
            HtmlResponseWrapper responseWrapper = new HtmlResponseWrapper((HttpServletResponse)response);
            chain.doFilter(request, (ServletResponse)responseWrapper);
            String content = responseWrapper.getCaptureAsString();
            if (response.getContentType() != null && response.getContentType().contains("text/html")) {
                content = content.replaceAll("(grid-(column|row)\\s*:[^;]*)\\s*/\\s*span\\s*([^;]*);", "$1; -ms-grid-$2-span: $3;");
                content = content.replaceAll("(grid-column|grid-row)\\s*:[^;]*;\\s?", "$0-ms-$0");
                content = content.replaceAll("grid-template-columns\\s*:([^;]*;)\\s?", "$0-ms-$0 -ms-grid-columns: $1");
                content = content.replaceAll("(-ms-grid-columns:.*)repeat\\(([^,]*),\\s*1fr\\)(\\s*[^;]*;)", "$1 (1fr)[$2]$3");
                response.getWriter().write(content);
            } else {
                response.getWriter().write(content);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

